/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.xmlrpc;

import java.io.IOException;
import java.util.Vector;
import jbridge.IOverrideCall;
import jbridge.RemoteRuntimeException;
import jbridge.Utils;
import jp.gr.java_conf.ccs2.util.StringUtil;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class XMLRPC_OverrideCall
implements IOverrideCall {
    private String host;
    private int port;

    public XMLRPC_OverrideCall(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Object call(Object sid, Object objectId, String methodName, Object[] args, Class rt) {
        Vector<Object> params = new Vector<Object>();
        params.addElement(sid);
        params.addElement(objectId);
        params.addElement(methodName);
        for (int i = 0; i < args.length; ++i) {
            params.addElement(args[i]);
        }
        try {
            XmlRpcClient xmlrpc = new XmlRpcClient("http://" + this.host + ":" + this.port + "/RPC2");
            Object obj = xmlrpc.execute("jb.call", params);
            if (obj != null) {
                Object ret;
                if (obj instanceof String) {
                    String retcode = (String)obj;
                    if (retcode.equals("$$$NULL$$$")) {
                        obj = null;
                    } else if (retcode.indexOf("$$$EXCEPTION$$$") == 0) {
                        String[] ss = StringUtil.split(retcode, "__$$$__");
                        throw new RemoteRuntimeException(ss[1], ss[2], ss[3]);
                    }
                } else if (obj != null && obj instanceof Number && (ret = Utils.convertObjectType(obj, rt)) != null) {
                    obj = ret;
                }
            }
            return obj;
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Remote method calling:" + objectId.toString() + "." + methodName + StringUtil.conbine(args), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Remote method calling:" + objectId.toString() + "." + methodName + StringUtil.conbine(args), e);
        }
    }
}

