/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.gr.java_conf.ccs2.core.CCSResource;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class DateComponent
extends JPanel {
    private Date date;
    private String hint;
    private boolean readonly = false;
    private JTextField ytext;
    private JTextField mtext;
    private JTextField dtext;

    public DateComponent() {
        this((String)null);
    }

    public DateComponent(String h) {
        this(new Date(), h, false);
    }

    public DateComponent(Date init, String hint, boolean r) {
        this.hint = hint;
        this.readonly = r;
        this.date = init;
        this.setupGui();
    }

    public void setDate(Date d) {
        this.date = d;
        this.updateFromData();
    }

    public Date getDate() {
        this.updateFromComp();
        return this.date;
    }

    public boolean isEnabled() {
        return this.readonly;
    }

    public void setEnabled(boolean t) {
        this.readonly = t;
        this.setEditable2(t);
    }

    public void setBackgroundComp(Color c) {
        if (c != null) {
            this.dtext.setBackground(c);
            this.ytext.setBackground(c);
            this.mtext.setBackground(c);
        }
    }

    public void requestFocus() {
        this.ytext.requestFocus();
    }

    private void setEditable2(boolean t) {
        this.dtext.setEditable(t);
        this.ytext.setEditable(t);
        this.mtext.setEditable(t);
    }

    private void setupGui() {
        this.setLayout(new FlowLayout(1));
        this.ytext = new JTextField(4);
        this.mtext = new JTextField(2);
        this.dtext = new JTextField(2);
        DCaretListener yc = new DCaretListener(this.ytext, 4);
        this.ytext.addCaretListener(yc);
        this.ytext.addFocusListener(new DFocusListener(yc, this.ytext));
        DCaretListener mc = new DCaretListener(this.mtext, 2);
        this.mtext.addCaretListener(mc);
        this.mtext.addFocusListener(new DFocusListener(mc, this.mtext));
        DCaretListener dc = new DCaretListener(this.dtext, 2);
        this.dtext.addCaretListener(dc);
        this.dtext.addFocusListener(new DFocusListener(dc, this.dtext));
        this.add(this.ytext);
        this.add(new JLabel(CCSResource.getResourceString("Year")));
        this.add(this.mtext);
        this.add(new JLabel(CCSResource.getResourceString("Month")));
        this.add(this.dtext);
        this.add(new JLabel(CCSResource.getResourceString("Date")));
        this.updateFromData();
    }

    private void updateFromData() {
        Calendar cal = Calendar.getInstance();
        if (this.date != null) {
            cal.setTime(this.date);
            int day = cal.get(5);
            int month = cal.get(2) + 1;
            int year = cal.get(1);
            NumberFormat form = NumberFormat.getInstance();
            this.ytext.setText(form.format(year));
            this.mtext.setText(form.format(month));
            this.dtext.setText(form.format(day));
        } else {
            this.ytext.setText("----");
            this.mtext.setText("--");
            this.dtext.setText("--");
        }
    }

    private void updateFromComp() {
        NumberFormat form = NumberFormat.getInstance();
        int day = 0;
        int mon = 0;
        int year = 0;
        String a = null;
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            String txt = this.dtext.getText();
            if (txt == null || txt.indexOf("--") != -1) {
                this.date = null;
                return;
            }
            a = StringUtil.transformZenkakuToHankaku(txt);
            day = form.parse(a).intValue();
            txt = this.mtext.getText();
            if (txt == null || txt.indexOf("--") != -1) {
                mon = calendar.get(2);
            } else {
                a = StringUtil.transformZenkakuToHankaku(txt);
                mon = form.parse(a).intValue() - 1;
            }
            txt = this.ytext.getText();
            if (txt == null || txt.indexOf("--") != -1) {
                year = calendar.get(1);
            } else {
                a = StringUtil.transformZenkakuToHankaku(txt);
                year = form.parse(a).intValue();
            }
        }
        catch (ParseException e) {
            if (a.indexOf("--") != -1) {
                this.date = null;
                return;
            }
            System.err.println(e.getMessage());
            Object[] ss = new String[]{this.hint};
            String mesf = CCSResource.getResourceString("BadDateField");
            String mes = MessageFormat.format(mesf, ss);
            JOptionPane.showMessageDialog(this, mes, CCSResource.getResourceString("BadDateField"), 0);
            this.date = null;
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        try {
            cal.set(year, mon, day);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.date = null;
            return;
        }
        this.date = cal.getTime();
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame("Date test");
        Container ct = f.getContentPane();
        ct.add((Component)new JLabel("Input date"), "North");
        final DateComponent dc = new DateComponent(new Date(), "Test date", false);
        ct.add((Component)dc, "Center");
        JButton b = new JButton("exit");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Date d = dc.getDate();
                if (d != null) {
                    System.out.println(StringUtil.datej(d));
                    System.exit(0);
                }
            }
        });
        ct.add((Component)b, "South");
        f.pack();
        f.show();
    }

    private class DFocusListener
    extends FocusAdapter {
        private DCaretListener caretListener;
        private JTextField textField;

        DFocusListener(DCaretListener c, JTextField f) {
            this.caretListener = c;
            this.textField = f;
        }

        public void focusGained(FocusEvent e) {
            this.caretListener.begin();
            if (this.textField.getText() != null) {
                this.textField.select(0, this.textField.getText().length());
            }
            this.caretListener.end();
        }
    }

    private class DCaretListener
    implements CaretListener {
        private int nextNumber;
        private JTextField component;
        private boolean modify = false;

        DCaretListener(JTextField f, int num) {
            this.component = f;
            this.nextNumber = num;
        }

        void begin() {
            this.modify = true;
        }

        void end() {
            this.modify = false;
        }

        public void caretUpdate(CaretEvent e) {
            if (this.component.getText() != null && this.component.getText().length() == this.nextNumber && !this.modify) {
                FocusManager.getCurrentManager().focusNextComponent(this.component);
            }
        }
    }
}

