/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jp.gr.java_conf.ccs2.util.TreeStructure;
import jp.gr.java_conf.ccs2.util.TreeStructureUtil;

public class TreeStructureSwingViewer {
    private JFrame frame;
    private JTree tree;

    public TreeStructureSwingViewer(TreeStructure root) {
        this.setTree(root);
    }

    public void setTree(TreeStructure root) {
        DefaultMutableTreeNode top = this.translate(root);
        this.show(top);
    }

    protected DefaultMutableTreeNode translate(TreeStructure root) {
        String name = root.getTreeNodeExpression();
        DefaultMutableTreeNode tn = new DefaultMutableTreeNode(name);
        TreeStructure[] children = root.getTreeNodes();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                tn.add(this.translate(children[i]));
            }
        }
        return tn;
    }

    protected void show(DefaultMutableTreeNode root) {
        if (this.frame == null) {
            this.frame = new JFrame("Tree Viewer");
            this.frame.setSize(500, 600);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        if (this.tree == null) {
            this.tree = new JTree(root);
            this.frame.getContentPane().add(new JScrollPane(this.tree));
        } else {
            this.tree.setModel(new DefaultTreeModel(root));
        }
        this.frame.show();
    }

    public static void main(String[] args) {
        TreeStructure root = TreeStructureUtil.getTestTreeObject(30);
        TreeStructureSwingViewer viewer = new TreeStructureSwingViewer(root);
    }
}

