/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import jp.gr.java_conf.ccs2.comp.OriginalFont;
import jp.gr.java_conf.ccs2.comp.RichString;
import jp.gr.java_conf.ccs2.util.TreeStructure;
import jp.gr.java_conf.ccs2.util.TreeStructureUtil;

public class TreeStructureViewer {
    private JFrame frame;
    private TreeViewer tree;

    public TreeStructureViewer(TreeStructure root) {
        this.setTree(root);
    }

    public void setTree(TreeStructure root) {
        this.show(root);
    }

    protected void show(TreeStructure root) {
        if (this.frame == null) {
            this.frame = new JFrame("Tree Viewer");
            this.frame.setSize(600, 500);
        }
        if (this.tree == null) {
            this.tree = new TreeViewer(root);
            JScrollPane sc = new JScrollPane(this.tree);
            this.frame.getContentPane().add(sc);
        } else {
            this.tree.setModel(root);
        }
        this.frame.show();
    }

    public static void main(String[] args) {
        TreeStructure root = TreeStructureUtil.getTestTreeObject(30);
        TreeStructureViewer viewer = new TreeStructureViewer(root);
    }

    class TreeViewer
    extends JComponent {
        int vSpace = 15;
        int hSpace = 15;
        OriginalFont fontInfo = new OriginalFont(Color.black, Color.lightGray, new Font("Serif", 0, 16));
        TreeStructure root;
        List paintList = new ArrayList();

        TreeViewer(TreeStructure t) {
            this.setModel(t);
        }

        public void setModel(TreeStructure t) {
            this.root = t;
        }

        public void paintComponent(Graphics g) {
            PaintNode node = this.adjustSize(g);
            this.painter(g, node, new Point(this.hSpace, this.vSpace), null);
        }

        PaintNode adjustSize(Graphics g) {
            this.paintList.clear();
            PaintNode tree = this.calcSize(g, this.root);
            int ww = tree.w + this.hSpace * 2;
            int hh = tree.h + this.vSpace * 2;
            Dimension d = this.getSize();
            if (d.width == ww && d.height == hh) {
                return tree;
            }
            this.setPreferredSize(new Dimension(ww, hh));
            return tree;
        }

        PaintNode calcSize(Graphics g, TreeStructure node) {
            RichString name = new RichString(node.getTreeNodeExpression(), this.fontInfo);
            Dimension tdim = name.getSize(g);
            TreeStructure[] children = node.getTreeNodes();
            Dimension dim = new Dimension(0, 0);
            PaintNode[] nodes = null;
            if (children != null && children.length > 0) {
                nodes = new PaintNode[children.length];
                for (int i = 0; i < children.length; ++i) {
                    PaintNode r;
                    nodes[i] = r = this.calcSize(g, children[i]);
                    dim.width += r.w + this.hSpace;
                    if (dim.height >= r.h) continue;
                    dim.height = r.h;
                }
                dim.height += tdim.height + this.vSpace;
            } else {
                dim = new Dimension(tdim.width, tdim.height);
            }
            return new PaintNode(name, dim.width, dim.height, nodes);
        }

        void painter(Graphics g, PaintNode node, Point ps, Point con) {
            int i;
            int xx;
            Dimension tdim = node.name.getSize(g);
            int mx = ps.x + node.w / 2 - tdim.width / 2;
            int my = ps.y;
            if (node.children != null) {
                int avx = 0;
                xx = 0;
                for (i = 0; i < node.children.length; ++i) {
                    avx += ps.x + xx + node.children[i].w / 2;
                    xx += node.children[i].w + this.hSpace;
                }
                mx = avx / node.children.length - tdim.width / 2;
            }
            if (con != null) {
                g.drawLine(mx + tdim.width / 2, my, con.x, con.y);
            }
            node.name.drawContents(g, mx, my);
            Point myCon = new Point(mx + tdim.width / 2, my + tdim.height);
            if (node.children != null) {
                xx = 0;
                for (i = 0; i < node.children.length; ++i) {
                    int cx = ps.x + xx;
                    int cy = ps.y + tdim.height + this.vSpace;
                    this.painter(g, node.children[i], new Point(cx, cy), myCon);
                    xx += node.children[i].w + this.hSpace;
                }
            }
        }

        class PaintNode {
            RichString name;
            int x;
            int y;
            int w;
            int h;
            PaintNode[] children;

            PaintNode(RichString n, int w, int h, PaintNode[] ns) {
                this.name = n;
                this.w = w;
                this.h = h;
                this.children = ns;
            }
        }
    }
}

