/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.util.StringUtil;

public abstract class AppConfig {
    private AppContext appContext;

    protected abstract Object getOptionObject(String var1);

    public abstract String[] getOptionKeys();

    public abstract String[] getArgumentFiles();

    public void setAppContext(AppContext app) {
        this.appContext = app;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    public String getDumpProperties() {
        StringBuffer sb = new StringBuffer();
        String[] keys = this.getOptionKeys();
        for (int i = 0; i < keys.length; ++i) {
            String cont = this.getOptionObject(keys[i]).toString();
            sb.append(keys[i] + ":" + cont + "\n");
        }
        String[] files = this.getArgumentFiles();
        for (int i = 0; i < files.length; ++i) {
            sb.append("FILE:" + files[i] + "\n");
        }
        return sb.toString();
    }

    public boolean getOption(String optionName) {
        return this.getOption(optionName, false);
    }

    public boolean getOption(String optionName, boolean def) {
        Object obj = this.getOptionObject(optionName);
        if (obj == null || !(obj instanceof Boolean)) {
            return def;
        }
        return (Boolean)obj == Boolean.TRUE;
    }

    public String getOptionString(String optionName) {
        return this.getOptionString(optionName, null);
    }

    public String getOptionString(String optionName, String def) {
        Object obj = this.getOptionObject(optionName);
        if (obj == null) {
            return def;
        }
        if (!(obj instanceof String)) {
            return obj.toString();
        }
        return (String)obj;
    }

    public int getOptionInteger(String optionName) {
        return this.getOptionInteger(optionName, -1);
    }

    public int getOptionInteger(String optionName, int def) {
        String ret = this.getOptionString(optionName);
        if (StringUtil.isNull(ret)) {
            return def;
        }
        try {
            return Integer.parseInt(ret);
        }
        catch (NumberFormatException e) {
            if (this.appContext != null) {
                this.appContext.getMonitor().warning("property [" + optionName + "] is wrong number.");
            }
            return def;
        }
    }

    public double getOptionDouble(String optionName) {
        return this.getOptionDouble(optionName, -1.0);
    }

    public double getOptionDouble(String optionName, double def) {
        String ret = this.getOptionString(optionName);
        if (StringUtil.isNull(ret)) {
            return def;
        }
        try {
            return Double.parseDouble(ret);
        }
        catch (NumberFormatException e) {
            if (this.appContext != null) {
                this.appContext.getMonitor().warning("property [" + optionName + "] is wrong number.");
            }
            return def;
        }
    }

    public String getArgumentFile() {
        if (this.getArgumentFiles().length == 0) {
            return null;
        }
        return this.getArgumentFiles()[0];
    }
}

