/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.core.DefaultAppConfig;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class MutableAppConfig
extends AppConfig {
    private static final Object NULL = new Object();
    private AppConfig config;
    private HashMap map = new HashMap();

    public MutableAppConfig(AppConfig parent) {
        this.config = parent;
    }

    public void setAppContext(AppContext app) {
        this.config.setAppContext(app);
    }

    public AppContext getAppContext() {
        return this.config.getAppContext();
    }

    public void setOptionObject(String key, Object content) {
        if (content == null) {
            this.map.put(key, NULL);
        } else {
            this.map.put(key, content);
        }
    }

    public String[] getOptionKeys() {
        LinkedList<String> keyList = new LinkedList<String>();
        String[] parentKeys = this.config.getOptionKeys();
        for (int i = 0; i < parentKeys.length; ++i) {
            if (this.getOptionObject(parentKeys[i]) == null) continue;
            keyList.add(parentKeys[i]);
        }
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.getOptionObject(key) == null || keyList.contains(key)) continue;
            keyList.add(key);
        }
        String[] newKeys = new String[keyList.size()];
        return keyList.toArray(newKeys);
    }

    public Object getOptionObject(String key) {
        Object obj = this.map.get(key);
        if (obj == NULL) {
            return null;
        }
        if (obj != null) {
            return obj;
        }
        return this.config.getOptionObject(key);
    }

    public String[] getArgumentFiles() {
        return this.config.getArgumentFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename)));
        try {
            String[] keys = this.getOptionKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (this.getOptionObject(keys[i]) == null || this.getOptionObject(keys[i]) == NULL) continue;
                out.print(keys[i]);
                out.print("=");
                out.println(this.getOptionObject(keys[i]).toString());
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public static void main(String[] a) throws IOException {
        String[] args = new String[]{"-abc:12", "-level:debug", "-output:true", "-mag:3.14", "-input:false", "file1"};
        DefaultAppConfig config = new DefaultAppConfig(args);
        System.out.println(config.getDumpProperties());
        StringUtil.assertEquals(config.getOptionString("level"), "debug");
        if (12 != config.getOptionInteger("abc")) {
            throw new RuntimeException(config.getOptionString("abc"));
        }
        if (!config.getOption("output")) {
            throw new RuntimeException(config.getOptionString("output"));
        }
        if (config.getOption("input")) {
            throw new RuntimeException(config.getOptionString("input"));
        }
        if (3.14 != config.getOptionDouble("mag")) {
            throw new RuntimeException();
        }
        StringUtil.assertEquals("file1", config.getArgumentFile());
        System.out.println("----------------");
        MutableAppConfig nconfig = new MutableAppConfig(config);
        nconfig.setOptionObject("abc", "33");
        nconfig.setOptionObject("level", null);
        nconfig.setOptionObject("new", "option");
        System.out.println(StringUtil.conbine(nconfig.getOptionKeys(), ", "));
        System.out.println(nconfig.getDumpProperties());
        if (nconfig.getOptionString("level") != null) {
            throw new RuntimeException(nconfig.getOptionString("level"));
        }
        if (33 != nconfig.getOptionInteger("abc")) {
            throw new RuntimeException(nconfig.getOptionString("abc"));
        }
        if (!nconfig.getOption("output")) {
            throw new RuntimeException(nconfig.getOptionString("output"));
        }
        if (nconfig.getOption("input")) {
            throw new RuntimeException(nconfig.getOptionString("input"));
        }
        if (3.14 != nconfig.getOptionDouble("mag")) {
            throw new RuntimeException();
        }
        nconfig.save("/temp/test.properties");
    }
}

