/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jp.gr.java_conf.ccs2.sql.JDBCUtil;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class ConnectionBean
implements Serializable {
    private String url;
    private String driver;
    private String user;
    private String password;
    private boolean driverExist = false;
    transient Connection connection;

    public ConnectionBean() {
    }

    public ConnectionBean(String driver, String url) {
        this.setDriver(driver);
        this.setUrl(url);
    }

    public ConnectionBean(String driver, String url, String user, String password) {
        this.setDriver(driver);
        this.setUrl(url);
        this.setUser(user);
        this.setPassword(password);
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String u) {
        this.password = u;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDriver(String d) {
        this.driver = d;
        this.driverExist = JDBCUtil.registDriver(this.driver);
    }

    public String getDriver() {
        return this.driver;
    }

    public Connection getConnection() throws SQLException {
        if (!this.driverExist) {
            throw new RuntimeException("Driver [" + this.driver + "] doesn't exist!");
        }
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.getConnectionPrv();
        }
        return this.connection;
    }

    private Connection getConnectionPrv() throws SQLException {
        if (StringUtil.isNull(this.user)) {
            if (StringUtil.isNull(this.url)) {
                throw new RuntimeException("No connection information (url, user, password)");
            }
            return DriverManager.getConnection(this.url);
        }
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException : " + e.getMessage() + " in ConnectionBean.");
        }
    }

    protected void finalize() {
        this.closeConnection();
    }
}

