/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import jp.gr.java_conf.ccs2.sql.DBAccess;
import jp.gr.java_conf.ccs2.sql.JDBCUtil;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;

public class DBAccessContext {
    private Connection connection;
    private String preparedSql = null;

    public DBAccessContext() {
    }

    public DBAccessContext(Connection connection) {
        this.initConnection(connection);
    }

    public void initConnection(Connection con) {
        this.connection = con;
    }

    public void setPreparedSql(String sql) {
        this.preparedSql = sql;
    }

    private Statement getStatement() throws SQLException {
        if (this.preparedSql == null) {
            return this.connection.createStatement();
        }
        return this.connection.prepareStatement(this.preparedSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doAccess(DBAccess client) {
        block11: {
            Statement stmt = null;
            stmt = this.getStatement();
            client.access(stmt);
            Object var5_3 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block11;
            }
            catch (SQLException e2) {
                client.exceptionHandler(e2);
            }
            break block11;
            {
                catch (SQLException e) {
                    client.exceptionHandler(e);
                    Object var5_4 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block11;
                    }
                    catch (SQLException e2) {
                        client.exceptionHandler(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    client.exceptionHandler(e2);
                }
                throw throwable;
            }
        }
    }

    public void doAccessAtOnce(DBAccess client) {
        this.doAccessAtOnce(new DBAccess[]{client});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAccessAtOnce(DBAccess[] clients) {
        if (clients == null || clients.length == 0) {
            return;
        }
        try {
            for (int i = 0; i < clients.length; ++i) {
                this.doAccess(clients[i]);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                clients[0].exceptionHandler(e);
            }
            throw throwable;
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            clients[0].exceptionHandler(e);
        }
    }

    public void doTransactionAccessAtOnce(DBAccess client, String[] tables) {
        this.doTransactionAccessAtOnce(new DBAccess[]{client}, tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doTransactionAccess(DBAccess[] clients, String[] tables) {
        block16: {
            if (clients == null || clients.length == 0) {
                return;
            }
            Statement stmt = null;
            NativeDBCommand command = null;
            this.connection.setAutoCommit(false);
            command = JDBCUtil.getNativeDBCommand(this.connection);
            stmt = this.getStatement();
            command.lockTables(stmt, tables, true);
            for (int i = 0; i < clients.length; ++i) {
                clients[i].access(stmt);
            }
            command.unlockTables(stmt, tables);
            this.connection.commit();
            Object var8_7 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block16;
            }
            catch (SQLException e2) {
                clients[0].exceptionHandler(e2);
            }
            break block16;
            {
                catch (SQLException e) {
                    if (command != null && stmt != null) {
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException ex) {
                            clients[0].exceptionHandler(ex);
                        }
                    }
                    clients[0].exceptionHandler(e);
                    Object var8_8 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block16;
                    }
                    catch (SQLException e2) {
                        clients[0].exceptionHandler(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    clients[0].exceptionHandler(e2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransactionAccessAtOnce(DBAccess[] clients, String[] tables) {
        try {
            this.doTransactionAccess(clients, tables);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                clients[0].exceptionHandler(e);
            }
            throw throwable;
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            clients[0].exceptionHandler(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doLockedAccessAtOnce(DBAccess client, String[] tables) {
        block17: {
            Statement stmt = null;
            NativeDBCommand command = null;
            command = JDBCUtil.getNativeDBCommand(this.connection);
            stmt = this.getStatement();
            this.connection.setAutoCommit(false);
            command.lockTables(stmt, tables, false);
            client.access(stmt);
            command.unlockTables(stmt, tables);
            this.connection.commit();
            Object var8_5 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
                break block17;
            }
            catch (SQLException e2) {
                client.exceptionHandler(e2);
            }
            break block17;
            {
                catch (SQLException e) {
                    if (command != null && stmt != null) {
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException ex) {
                            client.exceptionHandler(ex);
                        }
                    }
                    client.exceptionHandler(e);
                    Object var8_6 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (this.connection != null && !this.connection.isClosed()) {
                            this.connection.close();
                        }
                        break block17;
                    }
                    catch (SQLException e2) {
                        client.exceptionHandler(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (this.connection != null && !this.connection.isClosed()) {
                        this.connection.close();
                    }
                }
                catch (SQLException e2) {
                    client.exceptionHandler(e2);
                }
                throw throwable;
            }
        }
    }

    public void closeConnection(DBAccess client) {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            client.exceptionHandler(e);
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

