/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql.db;

import java.sql.SQLException;
import java.sql.Statement;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class OracleCommand
implements NativeDBCommand {
    private char[] orgChars = new char[]{'\\', '\"'};
    private String[] replaceChars = new String[]{"\\\\", "\\\""};

    public String getDBName() {
        return "Oracle";
    }

    public void lockTables(Statement stmt, String[] tables, boolean writeLock) throws SQLException {
        if (tables == null || tables.length == 0) {
            return;
        }
        boolean[] ls = new boolean[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            ls[i] = writeLock;
        }
        this.lockTables(stmt, tables, ls);
    }

    public void lockTables(Statement stmt, String[] tables, boolean[] writeLock) throws SQLException {
        if (tables == null || tables.length == 0) {
            return;
        }
        for (int i = 0; i < tables.length; ++i) {
            String sql = "LOCK TABLE ";
            sql = sql + tables[i];
            sql = writeLock[i] ? sql + " IN ACCESS EXCLUSIVE MODE" : sql + " IN ACCESS SHARE MODE";
            stmt.executeUpdate(sql);
        }
    }

    public void unlockTables(Statement stmt, String[] tables) throws SQLException {
    }

    public String escape(String text) {
        return StringUtil.escape(text, this.orgChars, this.replaceChars);
    }
}

