/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import jp.gr.java_conf.ccs2.io.FileSystemUtil;
import jp.gr.java_conf.ccs2.util.FileRotator;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class DateFileRotator
implements FileRotator {
    private File baseDir;
    private File targetFile;
    private String infoFile = ".ccs_lastRatatedTime";
    private long lastBackupedTime = -1L;
    private int backupIntervalDate = 7;
    private static SimpleDateFormat DF = new SimpleDateFormat("yyyy/MM/dd");

    public DateFileRotator(String targetFile, int backupIntervalDate) {
        this.setFilename(targetFile);
        this.backupIntervalDate = backupIntervalDate;
    }

    public void setFilename(String path) {
        this.targetFile = new File(path).getAbsoluteFile();
        this.baseDir = this.targetFile.getParentFile();
        this.lastBackupedTime = -1L;
    }

    public String getFilename() {
        return this.targetFile.getPath();
    }

    public void rotate() {
        if (!this.doesRotate()) {
            return;
        }
        this.backup();
    }

    private File getInfoFile() {
        return new File(this.baseDir.getPath() + "/" + this.infoFile);
    }

    private boolean doesRotate() {
        if (this.lastBackupedTime < 0L) {
            File info = this.getInfoFile();
            if (!info.exists()) {
                return true;
            }
            String stime = FileSystemUtil.file2String(info.getPath());
            if (!StringUtil.isNull(stime)) {
                try {
                    this.lastBackupedTime = DateFileRotator.getTheDayFirst(Long.parseLong(stime));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                return true;
            }
        }
        return System.currentTimeMillis() > this.getNextBackupTime();
    }

    private long getNextBackupTime() {
        return this.lastBackupedTime + (long)(86400000 * this.backupIntervalDate);
    }

    private static long getTheDayFirst(long day) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(day));
        GregorianCalendar first = new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5));
        return first.getTime().getTime();
    }

    private void backup() {
        File backupDir = new File(this.baseDir, DF.format(new Date()));
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        File backupFile = new File(backupDir, this.targetFile.getName());
        this.targetFile.renameTo(backupFile);
        this.lastBackupedTime = DateFileRotator.getTheDayFirst(System.currentTimeMillis());
        FileSystemUtil.string2File(Long.toString(this.lastBackupedTime), this.getInfoFile().getPath());
    }

    public static void main(String[] args) throws IOException {
        String file = "test.log";
        new File(file).createNewFile();
        DateFileRotator dfr = new DateFileRotator(file, 1);
        dfr.rotate();
    }
}

