/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class LSRFiles {
    private String fs = System.getProperty("file.separator");
    private boolean subdir = true;
    private Vector files = new Vector();

    public LSRFiles(String path) throws IOException {
        this(path, true);
    }

    public LSRFiles(String path, boolean subdir) throws IOException {
        if (path == null || path.equals("")) {
            path = System.getProperty("user.dir");
        }
        this.subdir = subdir;
        this.initFiles(path);
    }

    public static LSRFiles getLSR(String path) {
        LSRFiles lsr = null;
        try {
            lsr = new LSRFiles(path);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return lsr;
    }

    private void initFiles(String path) throws IOException {
        File tfile = new File(path);
        if (tfile.isFile()) {
            this.files.addElement(path);
        } else {
            Enumeration entries = this.getFilesByDir(path);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    this.files.addElement((String)entries.nextElement());
                }
            }
        }
        if (this.files.size() == 0) {
            System.err.println("file or directory not found.");
        }
    }

    private Enumeration getFilesByDir(String absolutePath) throws IOException {
        Vector<String> tempList = new Vector<String>();
        File dir = new File(absolutePath);
        if (!dir.isDirectory()) {
            return null;
        }
        String[] entries = dir.list();
        for (int i = 0; i < entries.length; ++i) {
            Enumeration e;
            String name = absolutePath + this.fs + entries[i];
            File tfile = new File(name);
            if (tfile.isFile()) {
                tempList.addElement(tfile.getAbsolutePath());
                continue;
            }
            if (!this.subdir || (e = this.getFilesByDir(name)) == null) continue;
            while (e.hasMoreElements()) {
                tempList.addElement((String)e.nextElement());
            }
        }
        return tempList.elements();
    }

    public void setFilenameFilter(FilenameFilter ff) {
        File[] tfiles = this.getFiles();
        if (tfiles == null) {
            return;
        }
        Vector<String> newFiles = new Vector<String>();
        for (int i = 0; i < tfiles.length; ++i) {
            File curFile = tfiles[i];
            String sdir = curFile.getParent();
            if (sdir == null) {
                curFile = new File(curFile.getAbsolutePath());
                sdir = curFile.getParent();
            }
            if (!ff.accept(new File(sdir), curFile.getName())) continue;
            newFiles.addElement(curFile.getPath());
        }
        this.files = newFiles;
    }

    public String[] getFilenames() {
        if (this.files.isEmpty()) {
            return null;
        }
        Enumeration e = this.files.elements();
        String[] filenames = new String[this.files.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            filenames[i] = (String)e.nextElement();
            ++i;
        }
        return filenames;
    }

    public File[] getFiles() {
        String[] filenames = this.getFilenames();
        if (filenames == null) {
            return null;
        }
        File[] tfiles = new File[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            tfiles[i] = new File(filenames[i]);
        }
        return tfiles;
    }

    public static void main(String[] args) {
        String dir = null;
        if (args.length != 0) {
            dir = args[0];
        }
        System.out.println("getting from [" + dir + "]");
        LSRFiles lsr = LSRFiles.getLSR(dir);
        String[] list = lsr.getFilenames();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(list[i]);
        }
    }
}

