/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.File;
import java.text.MessageFormat;
import jp.gr.java_conf.ccs2.util.FileRotator;

public class NumberFileRotator
implements FileRotator {
    private String logFile;
    private long logSize;
    private int logNumber;
    private static final String FILE_FORMAT = "{0}.{1}";

    public NumberFileRotator(String logFile, long logSize, int logNumber) {
        this.logFile = logFile;
        this.logSize = logSize;
        this.logNumber = logNumber;
    }

    public void setFilename(String path) {
        this.logFile = path;
    }

    public String getFilename() {
        return this.logFile;
    }

    public void rotate() {
        File file = new File(this.logFile);
        if (!file.exists() || this.logSize < 1L || this.logNumber < 1) {
            return;
        }
        if (file.length() >= this.logSize) {
            this.moveOldFiles();
        }
    }

    private void moveOldFiles() {
        Object[] args = new String[2];
        args[0] = this.logFile;
        for (int i = this.logNumber; i >= 0; --i) {
            File file = null;
            if (i > 0) {
                args[1] = Integer.toString(i);
                file = new File(MessageFormat.format(FILE_FORMAT, args));
            } else {
                file = new File(this.logFile);
            }
            if (!file.exists()) continue;
            if (i == this.logNumber) {
                file.delete();
                continue;
            }
            args[1] = Integer.toString(i + 1);
            File nextFile = new File(MessageFormat.format(FILE_FORMAT, args));
            file.renameTo(nextFile);
        }
    }
}

