/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.util.Enumeration;
import java.util.Vector;
import jp.gr.java_conf.ccs2.util.TimerListener;

public class Timer
implements Runnable {
    protected int interval;
    protected Vector listeners = new Vector();
    protected boolean once = false;
    protected Caller caller = new Caller();
    protected Thread thread;
    protected boolean exit = false;
    private boolean late = false;

    public Timer(TimerListener timerListener, int i) {
        this.interval = i;
        this.addTimerListener(timerListener);
    }

    public Timer(TimerListener timerListener, int i, boolean once) {
        this.interval = i;
        this.addTimerListener(timerListener);
        this.once = once;
    }

    public void addTimerListener(TimerListener t) {
        this.listeners.addElement(t);
    }

    public void removeTimerListener(TimerListener t) {
        this.listeners.removeElement(t);
    }

    public void removeAllTimerListener() {
        this.listeners.removeAllElements();
    }

    public void setInterval(int i) {
        this.interval = i;
    }

    public int getInterval() {
        return this.interval;
    }

    public void startTimer() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopTimer() {
        this.finish();
    }

    public void finish() {
        this.exit = true;
    }

    private final void invoke() {
        Thread t = new Thread(this.caller);
        t.start();
    }

    private final void sleep() {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException e) {
            System.out.println("interrupted...");
        }
    }

    public void run() {
        this.exit = false;
        if (this.once) {
            this.sleep();
            this.invoke();
            return;
        }
        while (!this.exit) {
            this.sleep();
            if (!this.caller.isWorking()) {
                this.invoke();
                continue;
            }
            if (this.late) continue;
            System.out.println("CPU doesn't catch up with your work.");
            this.late = true;
        }
    }

    public static void main(String[] arg) {
        Timer timer = new Timer(new TimerListener(){
            int a = 0;

            public void timeArrived() {
                this.a += 100;
                System.out.println("time!  : " + this.a);
            }
        }, 100);
        timer.startTimer();
    }

    class Caller
    implements Runnable {
        boolean working = false;

        Caller() {
        }

        synchronized boolean isWorking() {
            return this.working;
        }

        synchronized void setWorking(boolean b) {
            this.working = b;
        }

        public void run() {
            this.setWorking(true);
            Enumeration e = Timer.this.listeners.elements();
            while (e.hasMoreElements()) {
                ((TimerListener)e.nextElement()).timeArrived();
            }
            this.setWorking(false);
        }
    }
}

