/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import jp.gr.java_conf.ccs2.io.ConsoleReader;

public class ClassFileLoader
extends ClassLoader {
    protected Hashtable classes = new Hashtable();
    protected String path;

    public ClassFileLoader() {
        this.path = "";
    }

    public ClassFileLoader(String p) {
        if (p.length() != 0 && !p.endsWith("/")) {
            p = p + "/";
        }
        this.path = p;
    }

    public Class load(String name, boolean r) throws ClassNotFoundException {
        return this.loadClass(name, r);
    }

    protected Class loadClass(String name, boolean r) throws ClassNotFoundException {
        Class cl = (Class)this.classes.get(name);
        String errorMessage = null;
        if (cl == null) {
            try {
                return this.findSystemClass(name);
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                cl = this.buildClass(name);
            }
        }
        if (cl == null) {
            if (errorMessage != null) {
                throw new ClassNotFoundException(name + " : " + errorMessage);
            }
            throw new ClassNotFoundException(name);
        }
        if (r) {
            this.resolveClass(cl);
        }
        return cl;
    }

    private Class buildClass(String name) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.path + name + ".class"));
            return this.loadClass(in);
        }
        catch (Exception e) {
            System.out.println("class file not found : " + name);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(InputStream in) throws IOException {
        Class<?> clazz;
        block7: {
            try {
                int n;
                byte[] data = new byte[4096];
                int total = 0;
                while ((n = in.read(data, total, data.length - total)) >= 0) {
                    if ((total += n) != data.length) continue;
                    byte[] newdata = new byte[total * 2];
                    System.arraycopy(data, 0, newdata, 0, total);
                    data = newdata;
                }
                clazz = this.defineClass(null, data, 0, total);
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("class not loaded");
                }
            }
            in.close();
        }
        return clazz;
    }

    public static void main(String[] args) {
        ConsoleReader cin = new ConsoleReader();
        String filename = "";
        if (args.length == 0) {
            System.out.println("input class name");
            filename = cin.read();
        } else {
            filename = args[0];
        }
        try {
            ClassFileLoader god = new ClassFileLoader("");
            Class guy = god.load(filename, true);
            System.out.println("class [" + guy.getName() + "] loaded.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

