/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.gr.java_conf.ccs2.sql.DBAccess;
import jp.gr.java_conf.ccs2.sql.DBAccessContext;
import jp.gr.java_conf.ccs2.sql.LocalAccess;
import jp.gr.java_conf.ccs2.util.StringFilter;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class SQL2String {
    public static String CTRL = "%";
    private static char[] NONCTRL = new char[]{' ', '\n', '\r', '\"', '<', '>', '\'', '=', '(', ')', '-', '$', '&', '+', '*', '[', ']', '{', '}', ',', '/', ';', ':', '@', '\t', '!'};

    public static String getResult(Connection con, String sql) throws SQLException {
        final String fsql = sql;
        final String[] ret = new String[1];
        DBAccess access = new DBAccess(){

            public void access(Statement stat) throws SQLException {
                ResultSet set = stat.executeQuery(fsql);
                if (set != null && set.next()) {
                    ret[0] = set.getString(1);
                }
            }

            public void exceptionHandler(SQLException e) {
                e.printStackTrace();
            }
        };
        DBAccessContext ct = new DBAccessContext(con);
        ct.doAccessAtOnce(access);
        return ret[0];
    }

    public static String[] getLayoutedResults(Connection con, String sql, String layout) throws SQLException {
        return SQL2String.getLayoutedResults(con, sql, layout, null);
    }

    public static String[] getLayoutedResultsCont(Connection con, String sql, String layout) throws SQLException {
        return SQL2String.getLayoutedResultsCont(con, sql, layout, null);
    }

    public static String[] getLayoutedResults(Connection con, String sql, String layout, Map transformers) throws SQLException {
        LocalAccess la = new LocalAccess(transformers, sql, layout);
        DBAccessContext ct = new DBAccessContext(con);
        ct.doAccessAtOnce(la);
        return la.getResultString();
    }

    public static String[] getLayoutedResultsCont(Connection con, String sql, String layout, Map transformers) throws SQLException {
        LocalAccess la = new LocalAccess(transformers, sql, layout);
        DBAccessContext ct = new DBAccessContext(con);
        ct.doAccess(la);
        return la.getResultString();
    }

    public static String[] layoutData(String layout, ResultSet rs) throws SQLException {
        return SQL2String.layoutData(layout, rs, null);
    }

    public static String[] layoutData(String layout, ResultSet rs, Map map) throws SQLException {
        if (StringUtil.isNull(layout)) {
            return null;
        }
        if (rs == null) {
            return SQL2String.clearLayoutDatas(layout);
        }
        String[] columnNames = SQL2String.makeColumnArray(rs);
        ArrayList<String> rows = new ArrayList<String>();
        int row = 0;
        while (rs.next()) {
            String line = layout;
            for (int i = 0; i < columnNames.length; ++i) {
                line = SQL2String.transformWithMap(line, rs.getString(i + 1), columnNames[i], map);
            }
            rows.add(line);
            ++row;
        }
        String[] rets = new String[rows.size()];
        return rows.toArray(rets);
    }

    public static String layoutData(String layout, HashMap rs, Map map) {
        if (StringUtil.isNull(layout)) {
            return null;
        }
        if (rs == null || rs.size() == 0) {
            String[] ret = SQL2String.clearLayoutDatas(layout);
            return ret[0];
        }
        Iterator it = rs.keySet().iterator();
        String line = layout;
        while (it.hasNext()) {
            String colName = (String)it.next();
            String val = null;
            Object obj = rs.get(colName);
            val = obj instanceof String ? (String)obj : (obj == null ? "" : obj.toString());
            line = SQL2String.transformWithMap(line, val, colName, map);
        }
        return line;
    }

    private static String transformWithMap(String line, String data, String columnName, Map map) {
        if (map != null) {
            StringFilter tr;
            StringFilter all = (StringFilter)map.get("*");
            if (all != null) {
                data = all.applies(data);
            }
            if ((tr = (StringFilter)map.get(columnName)) != null) {
                data = tr.applies(data);
            }
        }
        return StringUtil.replace(line, SQL2String.columnCtrlCode(columnName), data);
    }

    private static String columnCtrlCode(String clmName) {
        return CTRL + clmName + CTRL;
    }

    private static String[] makeColumnArray(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        String[] columnNames = new String[cols];
        for (int i = 0; i < cols; ++i) {
            columnNames[i] = rsmd.getColumnName(i + 1).toLowerCase();
        }
        return columnNames;
    }

    private static String[] clearLayoutDatas(String in) {
        String[] ret = new String[]{SQL2String.clearLayoutData(in)};
        return ret;
    }

    private static String clearLayoutData(String in) {
        int pe;
        int ps;
        StringBuffer ret = new StringBuffer();
        block0: while ((ps = in.indexOf(CTRL)) != -1 && (pe = in.indexOf(CTRL, ps + 1)) != -1) {
            String ctrlStr = in.substring(ps, pe + 1);
            for (int i = 0; i < NONCTRL.length; ++i) {
                if (ctrlStr.indexOf(NONCTRL[i]) == -1) continue;
                ret.append(in.substring(0, pe));
                in = in.substring(pe);
                continue block0;
            }
            ret.append(in.substring(0, ps));
            in = in.substring(pe + 1);
        }
        ret.append(in);
        return ret.toString();
    }
}

