/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import jp.gr.java_conf.ccs2.io.EasyWriter;
import jp.gr.java_conf.ccs2.io.FileSystemUtil;

public class ResourceFile
extends ResourceBundle
implements Serializable {
    protected Hashtable resourcetable;
    protected String filename;

    public ResourceFile(Hashtable r, String f) {
        this.resourcetable = r;
        this.filename = f;
    }

    public ResourceFile(Hashtable r) {
        this.resourcetable = r;
        this.filename = null;
    }

    public Object handleGetObject(String key) throws MissingResourceException {
        Object obj = this.resourcetable.get(key);
        if (obj == null) {
            throw new MissingResourceException("no resource? [" + key + "]", this.filename, key);
        }
        return obj;
    }

    public Enumeration getKeys() {
        return this.resourcetable.keys();
    }

    public Hashtable getTable() {
        return this.resourcetable;
    }

    public boolean isEmpty() {
        return this.resourcetable.isEmpty();
    }

    public int size() {
        return this.resourcetable.size();
    }

    public String dumpAll() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.getKeys();
        if (!e.hasMoreElements()) {
            return "no contents\n";
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sb.append(key).append(" : ").append(this.getString(key)).append("\n");
        }
        return sb.toString();
    }

    public void put(String key, Object obj) {
        this.resourcetable.put(key, obj);
    }

    public void write() {
        ResourceFile.writeFile(this.filename, this.resourcetable);
    }

    public void write(Hashtable table) {
        ResourceFile.writeFile(this.filename, table);
    }

    public static ResourceFile getResourceFile(String file) {
        Vector source = FileSystemUtil.readFile(file);
        if (source == null) {
            System.err.println("file not found...[" + file + "]");
            return null;
        }
        Hashtable table = ResourceFile.parse(file, source);
        if (table == null) {
            System.err.println("parser error...[" + file + "]");
            return null;
        }
        return new ResourceFile(table, file);
    }

    private static Hashtable parse(String file, Vector source) {
        Enumeration e = source.elements();
        Hashtable<String, String> table = new Hashtable<String, String>();
        String a = null;
        int line = -1;
        try {
            while (e.hasMoreElements()) {
                ++line;
                a = (String)e.nextElement();
                if (a == null || a.length() == 0 || a.charAt(0) == '#') continue;
                int ps = a.indexOf("=");
                if (ps == -1) {
                    System.out.println(file + " : syntax error in " + line);
                    continue;
                }
                table.put(a.substring(0, ps).trim(), a.substring(ps + 1).trim());
            }
            return table;
        }
        catch (Exception ex) {
            System.err.println("ERROR : " + a + " : in " + line);
            return null;
        }
    }

    public static void writeFile(String file, Hashtable table) {
        if (file == null || table == null) {
            return;
        }
        EasyWriter out = new EasyWriter(file);
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            out.println(k + "=" + (String)table.get(k));
        }
        out.flush();
        out.close();
    }
}

