/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import jp.gr.java_conf.ccs2.core.DefaultMonitor;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.util.Counter;

public class Statistics {
    private MessageMonitor monitor;
    private HashMap statMap = new HashMap();
    private Calendar beginTime = Statistics.getTodayFirst();
    private static final long TIME_OF_ADAY = 86400000L;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

    public Statistics(MessageMonitor monitor) {
        this.monitor = monitor;
    }

    public synchronized long count(String id) {
        this.rotate();
        Counter c = this.getCounter(id);
        c.increment();
        return c.get();
    }

    public synchronized long get(String id) {
        return this.getCounter(id).get();
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer("---(Statistics report)--------\n");
        sb.append(DATE_FORMAT.format(this.beginTime.getTime())).append("\n");
        if (this.statMap.size() == 0) {
            sb.append("No statistics.\n");
        } else {
            Iterator it = this.statMap.keySet().iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                Counter counter = this.getCounter(id);
                sb.append(id).append(" : ");
                sb.append(Long.toString(counter.get()));
                sb.append("\n");
            }
        }
        sb.append("---------------------------");
        return sb.toString();
    }

    private static Calendar getTodayFirst() {
        GregorianCalendar cal = new GregorianCalendar();
        GregorianCalendar first = new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5));
        return first;
    }

    private void rotate() {
        long diff = System.currentTimeMillis() - this.beginTime.getTime().getTime();
        if (diff > 86400000L) {
            this.flush();
        }
    }

    public synchronized void flush() {
        this.monitor.normal(this.getReport());
        this.statMap.clear();
        this.beginTime = Statistics.getTodayFirst();
    }

    private Counter getCounter(String id) {
        Counter obj = (Counter)this.statMap.get(id);
        if (obj != null) {
            return obj;
        }
        obj = new Counter();
        this.statMap.put(id, obj);
        return obj;
    }

    public static void main(String[] args) {
        DefaultMonitor monitor = new DefaultMonitor();
        int num = 16;
        for (int i = 0; i < 8; ++i) {
            long time = Statistics.sample(monitor, new Statistics(monitor), num);
            monitor.normal("num=" + num + " : time=" + time);
            num *= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long sample(MessageMonitor monitor, Statistics target, int num) {
        int i;
        long begin = System.currentTimeMillis();
        Thread[] threads = new Thread[num];
        Counter finishCount = new Counter();
        Boolean waitObj = new Boolean(true);
        for (i = 0; i < num; ++i) {
            String id = Integer.toString(i);
            threads[i] = new Thread(Thread.currentThread().getThreadGroup(), new ThreadTester(target, id, num, finishCount, waitObj));
        }
        for (i = 0; i < num; ++i) {
            threads[i].start();
        }
        Boolean i2 = waitObj;
        synchronized (i2) {
            try {
                while (finishCount.get() != (long)num) {
                    waitObj.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int i3 = 0; i3 < num; ++i3) {
            int count = (int)target.get(Integer.toString(i3));
            if (count == num) continue;
            monitor.warning("Wrong : [" + i3 + "] = " + count + "(" + num + ")");
        }
        return System.currentTimeMillis() - begin;
    }

    static class ThreadTester
    implements Runnable {
        private String id;
        private int count;
        private Statistics target;
        private Object waitObj;
        private Counter finishCount;

        ThreadTester(Statistics target, String id, int count, Counter finishCount, Object obj) {
            this.id = id;
            this.count = count;
            this.target = target;
            this.waitObj = obj;
            this.finishCount = finishCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (int i = 0; i < this.count; ++i) {
                this.randomWait();
                this.target.count(Integer.toString(i));
            }
            Object object = this.waitObj;
            synchronized (object) {
                this.finishCount.increment();
                this.waitObj.notifyAll();
            }
        }

        private void randomWait() {
            try {
                Thread.sleep((int)(Math.random() * 10.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

