/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedList;
import jp.gr.java_conf.ccs2.util.TreeStructure;
import jp.gr.java_conf.ccs2.util.TreeStructureClass;

public class TreeStructureUtil {
    public static TreeStructure object2tree(Object obj, int depth) {
        HashSet collectedObjects = new HashSet();
        return TreeStructureUtil.object2tree("[ROOT]", obj, depth, collectedObjects);
    }

    private static TreeStructure object2tree(String fieldName, Object current, int depth, HashSet collectedObjects) {
        Object obj;
        Field[] fields = current.getClass().getFields();
        LinkedList<Object> currentFields = new LinkedList<Object>();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            obj = null;
            try {
                fields[i].setAccessible(true);
                obj = fields[i].get(current);
            }
            catch (IllegalAccessException e) {
                System.err.println("IllegalAccessException:" + name + ":" + fields[i].isAccessible());
                currentFields.add("X:" + name + ":" + fields[i].getDeclaringClass().getName());
                continue;
            }
            if (obj == null) {
                currentFields.add(name + ":null");
                continue;
            }
            if (collectedObjects.contains(obj)) {
                currentFields.add(name + ":ref=" + obj.getClass().getName() + "(" + obj.hashCode() + ")");
                continue;
            }
            if (obj instanceof Class) continue;
            if (obj.getClass().equals(Integer.TYPE) || obj instanceof Integer) {
                currentFields.add(name + ":int:" + (Integer)obj);
                continue;
            }
            if (obj.getClass().equals(Double.TYPE) || obj instanceof Double) {
                currentFields.add(name + ":double:" + (Double)obj);
                continue;
            }
            if (obj.getClass().equals(Float.TYPE) || obj instanceof Float) {
                currentFields.add(name + ":float:" + ((Float)obj).floatValue());
                continue;
            }
            if (obj.getClass().equals(Long.TYPE) || obj instanceof Long) {
                currentFields.add(name + ":long:" + (Long)obj);
                continue;
            }
            if (obj.getClass().equals(Boolean.TYPE) || obj instanceof Boolean) {
                currentFields.add(name + ":boolean:" + (Boolean)obj);
                continue;
            }
            if (obj.getClass().equals(Byte.TYPE) || obj instanceof Byte) {
                currentFields.add(name + ":byte:" + (Byte)obj);
                continue;
            }
            if (obj.getClass().equals(Short.TYPE) || obj instanceof Short) {
                currentFields.add(name + ":short:" + (Short)obj);
                continue;
            }
            if (obj instanceof String) {
                currentFields.add(name + ":" + (String)obj);
                continue;
            }
            collectedObjects.add(obj);
            if (depth == 0) {
                currentFields.add(name + ":" + obj.getClass().getName() + "...");
                continue;
            }
            currentFields.add(TreeStructureUtil.object2tree(name, obj, depth - 1, collectedObjects));
        }
        TreeStructure[] branch = new TreeStructure[currentFields.size()];
        for (int i = 0; i < branch.length; ++i) {
            obj = currentFields.get(i);
            branch[i] = obj instanceof String ? new TreeStructureClass((String)obj) : (TreeStructure)obj;
        }
        return new TreeStructureClass(fieldName + ":" + current.getClass().getName() + "(" + current.hashCode() + ")", branch);
    }

    public static TreeStructure getTestTreeObject(int num) {
        int i;
        Integer[] numbers = new Integer[num];
        for (i = 0; i < num; ++i) {
            numbers[i] = new Integer(i);
        }
        for (i = 0; i < num * 2; ++i) {
            int i2;
            int i1 = (int)(Math.random() * (double)num);
            if (i1 == (i2 = (int)(Math.random() * (double)num))) continue;
            Integer t = numbers[i1];
            numbers[i1] = numbers[i2];
            numbers[i2] = t;
        }
        NumberNode root = new NumberNode(numbers[0]);
        for (int i2 = 1; i2 < num; ++i2) {
            root.add(numbers[i2]);
        }
        return root;
    }

    static class NumberNode
    implements TreeStructure {
        private Integer number;
        private NumberNode small;
        private NumberNode large;

        NumberNode(Integer n) {
            this.number = n;
        }

        void add(Integer n) {
            if (this.number.compareTo(n) < 0) {
                if (this.large == null) {
                    this.large = new NumberNode(n);
                } else {
                    this.large.add(n);
                }
            } else if (this.small == null) {
                this.small = new NumberNode(n);
            } else {
                this.small.add(n);
            }
        }

        public String getTreeNodeExpression() {
            return this.number.toString();
        }

        public TreeStructure[] getTreeNodes() {
            if (this.small == null && this.large == null) {
                return null;
            }
            if (this.small != null && this.large != null) {
                return new TreeStructure[]{this.small, this.large};
            }
            if (this.small != null) {
                return new TreeStructure[]{this.small};
            }
            return new TreeStructure[]{this.large};
        }
    }
}

