package jbridge;

import java.io.IOException;
import jp.gr.java_conf.ccs2.core.*;
import org.apache.xmlrpc.XmlRpc;


public class BridgeBuilder extends AppContextClass {

	public static void main(String[] args) {
		if (args.length == 1 && "-h".equals(args[0])) {
			printHelp();
			return;
		}
		try {
			new BridgeBuilder(args).start();
		} catch (Exception e) {
			e.printStackTrace();
			errorExit(e.getClass().getName()+" : "+e.getMessage());
		}
	}

	private static void errorExit(String message) {
		System.err.println("Startup failed. : "+message);
		System.exit(0);
	}

	protected BridgeBuilder(String [] args) {
		super(args);
		((DefaultMonitor)getMonitor()).setFormat(MessageMonitor.FORMAT_MESSAGE);
	}

	protected void start() throws Exception {
		getMonitor().debug("Start main routine.");
		startupServer();
		System.out.println("OK.");
	}

	private IBridgeBuilder getBridgeBuilder() throws Exception {
		Class c = Class.forName(getConfig().getArgumentFile());
		return (IBridgeBuilder)c.newInstance();
	}

	private void startupServer() throws Exception {
		IBridgeBuilder builder = getBridgeBuilder();
		builder.setConfig(getMonitor(),getConfig());
		BridgeServer server = new BridgeServer(getMonitor(),
											   builder.getOverrideCaller(),
											   builder.getObjectTransformer());
		builder.start(server);
	}

	private static void printHelp() {
		System.out.println("> java jbridge.BridgeBuilder (bridge builder classname)");
	}
}