/* CCS, Class Collection by Sakurai
 *	Copyright (C) 1999-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import java.util.*;
import javax.swing.JComponent;

import ccs.comp.ngraph.*;
import ccs.math.*;

public class SwingPlotComponent extends JComponent implements PlotComponent {

	private Vector rendererList = new Vector();
	private Dimension lastSize = null;


	public SwingPlotComponent() {
		super();
	}

	public SwingPlotComponent(int width, int height) {
		super();
		setPreferredSize(new Dimension(width,height));
	}

	/**
	   @param renderer    PlotRenderer object
	   @param configRatio configuration ratio that must be 2D object.<pre>
	   configRatio.x : 0.0(left) - 1.0(right)
	   configRatio.y : 0.0(top) - 1.0(bottom)
	   configRatio.width : 0.0(zero) - 1.0(full width)
	   configRatio.height : 0.0(zero) - 1.0(full height)
	   </pre>
	 */
	public void addRenderer(PlotRenderer renderer,RealRange configRatio) {
		if (renderer == null) return;
		if (configRatio == null) {
			configRatio = new RealRange(0,0,1,1);
		} else if (configRatio.getDimension() != 2) {
			System.err.println("Configration ratio is invalid. ["+configRatio.getDimension()+"]");
			return;
		}
		RendererHolder holder = new RendererHolder();
		holder.renderer = renderer;
		holder.configRatio = configRatio;
		rendererList.addElement(holder);
		renderer.setParentComponent(this);
	}

	public void addRenderer(PlotRenderer renderer) {
		addRenderer(renderer,null);
	}

	public Component getComponent() {
		return this;
	}

	public void repaintOrder() {
		repaint();
	}

	public void paintComponent(Graphics g) {
		Dimension size = getSize();
		Rectangle borderArea = new Rectangle();
		for (int i=0;i<rendererList.size();i++) {
			RendererHolder holder = (RendererHolder)rendererList.elementAt(i);
			RealRange ratio = holder.configRatio;
			borderArea.x = (int)(size.width*ratio.x());
			borderArea.y = (int)(size.height*ratio.y());
			borderArea.width = (int)(size.width*ratio.width());
			borderArea.height = (int)(size.height*ratio.height());
			holder.renderer.paint(g,borderArea);
		}
	}

	class RendererHolder {
		PlotRenderer renderer;
		RealRange configRatio;
	}

}
