/* CCS, Class Collection by Sakurai
 *	Copyright (C) 1999-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import ccs.comp.d3.Renderer;
import ccs.comp.d3.RendererComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class SwingRendererComponent extends JComponent implements RendererComponent {

	private Rectangle paintRegion;
	private Renderer renderer;
	private Dimension lastSize;

	public SwingRendererComponent(int width, int height) {
		super();
		setPreferredSize(new Dimension(width,height));
		paintRegion = new Rectangle(0,0,width,height);
	}

	public void repaintOrder() {
		repaint();
	}

	public void onResizeCanvas() {
		Dimension d = getSize();
		if (d == null) return;
		paintRegion = new Rectangle(0,0,d.width,d.height);
		if (renderer == null) return;
		renderer.updatePaintRegion();
	}

	public void setRenderer(Renderer renderer) {
		this.renderer = renderer;
	}

	public void paintComponent(Graphics g) {
		Dimension d = getSize();
		if (d == null) return;
		if (d.width != paintRegion.width ||
			d.height != paintRegion.height) {
			paintRegion = new Rectangle(0,0,d.width,d.height);
			if (renderer == null) return;
			renderer.updatePaintRegion();
		}
		renderer.paint(g);
	}

	public Rectangle getPaintRegion() {
		return paintRegion;
	}

	public Component getComponent() {
		return this;
	}

}
