/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;

/** 
	Record application messages. 
 */
public interface MessageMonitor {

	/** debug message */
	public static final int DEBUG = 0;
	/** verbose message */
	public static final int VERBOSE = 1;
	/** normal message */
	public static final int NORMAL = 2;
	/** system meets some error or exception,
		which can be caught. */
	public static final int WARNING = 3;
	/** system meets a fatal error,
		which can not be recovered. */
	public static final int ERROR = 4;

	public static final String FORMAT_DATE = "%date%";
	public static final String FORMAT_LEVEL = "%level%";
	public static final String FORMAT_MESSAGE = "%message%";

	public static final String [] LEVELS = {
		"DEBUG","VERBOSE","NORMAL","WARNING","ERROR"};

	public int getLogLevel();

	public void setLogLevel(int level);

	public void message(int aslevel,String message);

	public void debug(String message);

	public void verbose(String message);

	public void normal(String message);

	public void warning(String message);

	public void error(String message);

	public void debugStackTrace(String message);

	public void recordStackTrace(Throwable t);

}
