/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.io;
import java.io.*;
import jp.gr.java_conf.ccs2.util.StringUtil;


/** simple output utility */
public class EasyWriter {

	protected PrintWriter out;

	//======== constructor

	/** cannot construct with no file */
	private EasyWriter() {}

	/** Standerd constructor 
	 * @param filename the filename which you wanna open as output.
	 */
	public EasyWriter(String filename) {
		this(filename,null);
	}

	/** Standerd constructor 
	 * @param filename the filename which you wanna open as output.
	 */
	public EasyWriter(String filename,String encoding) {
		out = openOutput(filename,encoding);
	}

	//======= operation

	/** If file was opened correctly, return true. */
	public boolean isOk() {
		if (out == null) return false;
		return true;
	}

	/** close the output stream.
	 * (you cannot use this object for good.) 
	 */
	public void close() {
		out.flush();
		out.close();
	}

	/** clear the output buffer.
	 * you must flush the buffer when finished to use.
	 */
	public void flush() {
		out.flush();
	}

	/**
	   return PrintWriter object
	*/
	public PrintWriter getWriter() {
		return out;
	}

	/** output a string data and add return "\n" code. */
	public void println(String a) {
		out.println(a);
	}

	/** output a string data. (this method don't return.) */
	public void print(String a) {
		out.print(a);
	}

	//======= private area

	/** low level open method
	 * @param filename the filename which you wanna open as output.
	 */
	public static PrintWriter openOutput(String filename,String encoding) {
		if (StringUtil.isNull(encoding))
			encoding = System.getProperty("file.encoding");
		if (filename == null || filename.equals("")) {
			System.out.println("*** null filename. ***");
			return null;
		}
		PrintWriter tout=null;
		try {
			tout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename),encoding));
		} catch(IOException e) {
			System.out.println("*** I/O Exception was occured. ****");
		}
		return tout;
	}

	/** test method (usage of this class) */
	public static void main(String [] args) {
		EasyWriter file = new EasyWriter("test1");
		file.println("hello world");
		if (args.length!=0) {
			for(int i=0;i<args.length;i++) 
				file.println(args[i]);
		}
		file.println("ok.");
		file.flush();
	}
}

