/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.io;
import java.io.*;
import java.util.Vector;


/** File System utility class. */
public class FileSystemUtil {

	/** 
	 *@param  src source file name.
	 *@param  dist distnation file name.
	 *@return return true if succeed.
	 */
	public static boolean copy(String src,String dist) {
		BufferedInputStream in = null;
		BufferedOutputStream out = null;
		String message = "Opening files";
		boolean success = false;
		try {
			in = new BufferedInputStream(new FileInputStream(src) );
			out	 = new BufferedOutputStream(new FileOutputStream(dist));
			message = "Copying files";
			File source = new File(src);
			long sz = source.length();
			for(long i = 0;i<sz;i++) {
				out.write(in.read());
			}
			success = true;
		}catch(Exception e) {
			System.err.println(e.getClass().getName()+"	 "+
							   e.getMessage()+"	 in FS.copy.["+message+"]");
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch(Exception ex) {
					System.err.println("IOException dring closing src file.");
				}
			}
			if (out != null) {
				try {
					out.flush();
					out.close();
				}catch(Exception ex) {
					System.err.println("IOException dring closing target file.");
				}
			}
		}
		return success;
	}

	/** [UTILITY]
	 * read a file and store lines into a list container 
	 */
	public static Vector readFile(String filename) {
		return readFile(filename,System.getProperty("file.encoding"));
	}
	/** [UTILITY]
	 * read a file and store lines into a list container 
	 */
	public static Vector readFile(String filename,String encoding) {
		if (filename == null) {
			return null;
		}
		Vector source = new Vector();
		try {
			EasyReader reader = new EasyReader(filename,encoding);
			while(!reader.isEOF()) {
				source.addElement(reader.read());
			}
		} catch(RuntimeException e) {
			System.err.println(e.getMessage());
			System.err.println(e.getClass().getName()+" ["+filename+"]");
			return null;
		}
		return source;
	}

	/** [UTILITY]
	 * read a file and store a string object
	 */
	public static String file2String(String filename) {
		return file2String(filename,System.getProperty("file.encoding"));
	}

	/** [UTILITY]
	 * read a file and store a string object
	 */
	public static String file2String(String filename,String encoding) {
		try {
			BufferedReader in =  new BufferedReader(new InputStreamReader(new FileInputStream(filename),encoding));
			StringBuffer out = new StringBuffer();
			while (in.ready()) {
				out.append(in.readLine());
				if (in.ready()) {
					out.append("\n");
				}
			}
			return out.toString();
		} catch (IOException e) {
		}
		return null;
	}

	public static void string2File(String source,String filename) {
		EasyWriter out = new EasyWriter(filename);
		out.print(source);
		out.close();
	}

	public static void string2File(String source,String filename,String encoding) {
		EasyWriter out = new EasyWriter(filename,encoding);
		out.print(source);
		out.close();
	}
}

