/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.sql;
import java.sql.*;
import java.io.Serializable;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class ConnectionBean implements Serializable {

	private String url,driver,user,password;
	private boolean driverExist = false;

	transient Connection connection;
	
	public ConnectionBean() {
	}

	public ConnectionBean(String driver,String url) {
		setDriver(driver);
		setUrl(url);
	}

	public ConnectionBean(String driver,String url,
						  String user,String password) {
		setDriver(driver);
		setUrl(url);
		setUser(user);
		setPassword(password);
	}

	public void setUrl(String u) {url = u;}
	public String getUrl() {return url;}
	public void setUser(String u) {user = u;}
	public String getUser() {return user;}
	public void setPassword(String u) {password = u;}
	public String getPassword() {return password;}
	public void setDriver(String d) {
		driver = d;
		driverExist = JDBCUtil.registDriver(driver);
	}
	public String getDriver() {return driver;}

	public Connection getConnection() throws SQLException {
		if (!driverExist) {
			throw new RuntimeException("Driver ["+driver+"] doesn't exist!");
		}
		if (connection == null || connection.isClosed()) {
			connection = getConnectionPrv();
		}
		return connection;
	}

	private Connection getConnectionPrv() throws SQLException {
		if (StringUtil.isNull(user)) {
			if (StringUtil.isNull(url)) throw new RuntimeException("No connection information (url, user, password)");
			return DriverManager.getConnection(url);
		}
		return DriverManager.getConnection(url,user,password);
	}
	
	public void closeConnection() {
		try {
			if (connection != null)
				connection.close();
		} catch (SQLException e) {
			System.err.println("SQLException : "+e.getMessage() +" in ConnectionBean.");
		}
	}

	protected void finalize() {
		closeConnection();
	}
}


