/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.sql;
import java.sql.*;
import java.io.Serializable;
import java.util.Map;
import jp.gr.java_conf.ccs2.util.StringUtil;


public class QueryBean implements Serializable {

	private Connection connection;
	private String sql,layout,empty;

	public QueryBean() {
	}

	public QueryBean(Connection cb,String sql) {
		this(cb,sql,null);
	}

	public QueryBean(Connection cb,String sql,String layout) {
		connection = cb;
		this.sql = sql;
		this.layout = layout;
	}

	public void setConnection(Connection c) {
		connection = c;
	}
	public Connection getConnection() {
		return connection;
	}

	public String getSql() {
		return sql;
	}
	
	public void setSql(String  v) {
		this.sql = v;
	}
	
	public void setLayout(String l) {
		this.layout = l;
	}
	public String getLayout() {return layout;}

	public void setEmptyLayout(String l) {
		this.empty = l;
	}
	public String getEmptyLayout() {return empty;}

	public String [] layoutResultSet() throws SQLException {
		return layoutResultSet(null);
	}

	public String [] layoutResultSet(Map transformers) throws SQLException {
		return SQL2String.getLayoutedResults(connection,sql,layout,transformers);
	}

	public String getLayoutedResultString(Map transformers) throws SQLException {
		return StringUtil.conbine(layoutResultSet(transformers));
	}

	public String getLayoutedResultString() throws SQLException {
		return getLayoutedResultString(null);
	}

}
