/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.util.*;
import java.io.File;

/** File filer utility (Java2) */
public class ExtensionFileFilter extends javax.swing.filechooser.FileFilter implements java.io.FileFilter, java.io.FilenameFilter {

	private String dec;
	private Vector exts = new Vector();

	public ExtensionFileFilter() {
	}

	public ExtensionFileFilter(String e) {
		exts.addElement(e);
	}

	public void addExtension(String e) {
		exts.addElement(e);
	}
	public String getDescription() {
		return dec;
	}
	public void setDescription(String s) {
		dec = s;
	}
	
	public boolean accept(File dir,String name) {
		Enumeration e = exts.elements();
		while(e.hasMoreElements()) {
			String ex = (String)e.nextElement();
			if (name.endsWith(ex))
				return true;
		}
		return false;
	}

	public boolean accept(File f) {
		if (f.isDirectory())
			return true;
		String n = f.getName();
		return accept(null,n);
	}
}

