package jp.gr.java_conf.ccs2.util;
import jp.gr.java_conf.ccs2.core.*;
import java.util.*;
import java.text.*;

public class Statistics {

	private MessageMonitor monitor;
	private HashMap statMap = new HashMap();
	private Calendar beginTime = getTodayFirst();
	private final static long TIME_OF_ADAY = 24*3600*1000;
	private final static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

	public Statistics(MessageMonitor monitor) {
		this.monitor = monitor;
	}

	public synchronized long count(String id) {
		rotate();
		Counter c = getCounter(id);
		c.increment();
		return c.get();
	}

	public synchronized long get(String id) {
		return getCounter(id).get();
	}

	public String getReport() {
		StringBuffer sb = new StringBuffer("---(Statistics report)--------\n");
		sb.append(DATE_FORMAT.format(beginTime.getTime())).append("\n");
		if (statMap.size() == 0) {
			sb.append("No statistics.\n");
		} else {
			Iterator it = statMap.keySet().iterator();
			while(it.hasNext()) {
				String id = (String)it.next();
				Counter counter = getCounter(id);
				sb.append(id).append(" : ");
				sb.append(Long.toString(counter.get()));
				sb.append("\n");
			}
		}
		sb.append("---------------------------");
		return sb.toString();
	}

	private static Calendar getTodayFirst() {
		GregorianCalendar cal = new GregorianCalendar();
		GregorianCalendar first = 
			new GregorianCalendar(cal.get(Calendar.YEAR),
								  cal.get(Calendar.MONTH),
								  cal.get(Calendar.DATE));
		return first;
	}

	private void rotate() {
		long diff = System.currentTimeMillis() - beginTime.getTime().getTime();
		if (diff > TIME_OF_ADAY) {
			flush();
		}
	}

	public synchronized void flush() {
		monitor.normal(getReport());
		statMap.clear();
		beginTime = getTodayFirst();
	}

	private Counter getCounter(String id) {
		Counter obj = (Counter)statMap.get(id);
		if (obj != null) return obj;
		obj = new Counter();
		statMap.put(id,obj);
		return obj;
	}

	//=======================================================

	public static void main(String [] args) {
		DefaultMonitor monitor = new DefaultMonitor();
		int num = 16;
		for(int i=0;i<8;i++) {
			long time = sample(monitor,new Statistics(monitor),num);
			monitor.normal("num="+num+" : time="+time);
			num *= 2;
		}
	}

	private static long sample(MessageMonitor monitor,
							   Statistics target,int num) {
		long begin = System.currentTimeMillis();
		Thread [] threads = new Thread[num];
		Counter finishCount = new Counter();
		Object waitObj = new Boolean(true);
		for (int i=0;i<num;i++) {
			String id = Integer.toString(i);
			threads[i] = new Thread(Thread.currentThread().getThreadGroup(),new ThreadTester(target,id,num,finishCount,waitObj));
		}
		for (int i=0;i<num;i++) {
			threads[i].start();
		}
		synchronized(waitObj) {
			try {
				while(finishCount.get() != num) {
					waitObj.wait();
				}
			} catch (Exception e) {
			}
		}
		for (int i=0;i<num;i++) {
			int count = (int)(target.get(Integer.toString(i)));
			if ( count != num) {
				monitor.warning("Wrong : ["+i+"] = "+count +"("+num+")");
			}
		}
		return System.currentTimeMillis()-begin;
	}

	static class ThreadTester implements Runnable {
		private String id;
		private int count;
		private Statistics target;
		private Object waitObj;
		private Counter finishCount;
		ThreadTester(Statistics target,String id,int count,
					 Counter finishCount,Object obj) {
			this.id = id;
			this.count = count;
			this.target = target;
			this.waitObj = obj;
			this.finishCount = finishCount;
		}
		
		public void run() {
			for(int i=0;i<count;i++) {
				randomWait();
				target.count(Integer.toString(i));
			}
			synchronized(waitObj) {
				finishCount.increment();
				waitObj.notifyAll();
			}
		}

		private void randomWait() {
			try {
				Thread.sleep((int)(Math.random()*10));
			} catch(InterruptedException e) {
			}
		}

	}

}

class Counter {
	private long count = 0;
	void increment() {
		count++;
	}
	void reset() {
		count=0;
	}
	long get() {
		return count;
	}
}

