/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;

import jp.gr.java_conf.ccs2.util.TreeStructure;
import java.util.HashSet;
import java.util.LinkedList;
import java.lang.reflect.Field;




/** 
 * TreeStructure utillity 
 */ 
public class TreeStructureUtil {

	/**
	   @param obj target object
	   @param depth traverse depth. if negative value, traverse all relation.
	 */
	public static TreeStructure object2tree(Object obj,int depth) {
		HashSet collectedObjects = new HashSet();
		return object2tree("[ROOT]",obj,depth,collectedObjects);
	}

	private static TreeStructure object2tree(String fieldName,
											 Object current,int depth,
											 HashSet collectedObjects) {
		Field [] fields = current.getClass().getFields();
		LinkedList currentFields = new LinkedList();
		for(int i=0;i<fields.length;i++) {
			String name = fields[i].getName();
			Object obj = null;
			try {
				fields[i].setAccessible(true);
				obj = fields[i].get(current);
			} catch (IllegalAccessException e) {
				System.err.println("IllegalAccessException:"+name+":"+fields[i].isAccessible());
				currentFields.add("X:"+name+":"+fields[i].getDeclaringClass().getName());
				continue;
			}
			if (obj == null) {
				currentFields.add(name+":null");
			} else if (collectedObjects.contains(obj)) {
				currentFields.add(name+":ref="+obj.getClass().getName()+"("+obj.hashCode()+")");
			} else if (obj instanceof Class) {
				//skip
			} else {
				if (obj.getClass().equals(Integer.TYPE) || 
					obj instanceof Integer) {
					currentFields.add( name+":int:"+((Integer)obj).intValue() );
				} else if (obj.getClass().equals(Double.TYPE) || 
						   obj instanceof Double) {
					currentFields.add( name+":double:"+((Double)obj).doubleValue() );
				} else if (obj.getClass().equals(Float.TYPE) || 
						   obj instanceof Float) {
					currentFields.add( name+":float:"+((Float)obj).floatValue() );
				} else if (obj.getClass().equals(Long.TYPE) || 
						   obj instanceof Long) {
					currentFields.add( name+":long:"+((Long)obj).longValue() );
				} else if (obj.getClass().equals(Boolean.TYPE) || 
						   obj instanceof Boolean) {
					currentFields.add( name+":boolean:"+((Boolean)obj).booleanValue() );
				} else if (obj.getClass().equals(Byte.TYPE) || 
						   obj instanceof Byte) {
					currentFields.add( name+":byte:"+((Byte)obj).byteValue() );
				} else if (obj.getClass().equals(Short.TYPE) || 
						   obj instanceof Short) {
					currentFields.add( name+":short:"+((Short)obj).shortValue() );
				} else if (obj instanceof String ) {
					currentFields.add( name+":"+((String)obj) );
				} else {
					collectedObjects.add(obj);
					if (depth == 0) {
						currentFields.add( name+":"+obj.getClass().getName()+"..." );
					} else {
						currentFields.add( object2tree(name,obj,depth-1,collectedObjects) );
					}
					}
			}
		}
		TreeStructure [] branch = new TreeStructure[currentFields.size()];
		for(int i=0;i<branch.length;i++) {
			Object obj = currentFields.get(i);
			if (obj instanceof String) {
				branch[i] = new TreeStructureClass((String)obj);
			} else {
				branch[i] = (TreeStructure)obj;
			}
		}
		return new TreeStructureClass(fieldName+":"+current.getClass().getName()+"("+current.hashCode()+")",branch);
	}

	public static TreeStructure getTestTreeObject(int num) {
		Integer[] numbers = new Integer[num];
		for(int i=0;i<num;i++) {
			numbers[i] = new Integer(i);
		}
		for(int i=0;i<num*2;i++) {
			int i1 = (int)(Math.random()*num);
			int i2 = (int)(Math.random()*num);
			if (i1 == i2) continue;
			Integer t = numbers[i1];
			numbers[i1] = numbers[i2];
			numbers[i2] = t;
		}
		NumberNode root = new NumberNode(numbers[0]);
		for(int i=1;i<num;i++) {
			root.add(numbers[i]);
		}
		return root;
	}
	
	static class NumberNode implements TreeStructure {
		private Integer number;
		private NumberNode small,large;
		NumberNode(Integer n) {
			number = n;
		}

		void add(Integer n) {
			if (number.compareTo(n) < 0) {
				if (large == null) {
					large = new NumberNode(n);
				} else {
					large.add(n);
				}
			} else {
				if (small == null) {
					small = new NumberNode(n);
				} else {
					small.add(n);
				}
			}
		}

		public String getTreeNodeExpression() {
			return number.toString();
		}
		
		public TreeStructure[] getTreeNodes() {
			if (small == null && large == null) {
				return null;
			}
			if (small != null && large != null) {
				return new TreeStructure[]{small,large};
			}
			if (small != null) {
				return new TreeStructure[]{small};
			} else {
				return new TreeStructure[]{large};
			}
		}
	}
	
}

