package jbridge;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import java.util.ArrayList;


public class MethodFinder {

	private MessageMonitor monitor;

	private HashMap publicClassTable = new HashMap();
	private HashMap allClassTable = new HashMap();

	public MethodFinder(MessageMonitor mon) {
		monitor = mon;
	}

	public Constructor searchConstructur(Class cls,Object[] args) throws NoSuchMethodException {
		Constructor[] cs = cls.getConstructors();
		if (cs == null || cs.length == 0) {
			throw new NoSuchMethodException("No declared constructor.");
		}
		if (args == null) {
			args = new Object[0];
		}
		for(int i=0;i<cs.length;i++) {
			if (isMatched(cs[i],args)) {
				return cs[i];
			}
		}
		return cls.getConstructor(Utils.object2class(args));
	}

	private boolean isMatched(Constructor constructor,Object[] args) {
		return compareParams(constructor.getParameterTypes(),args);
	}

	public Method searchStaticMethod(Class cls,String name,Object[] args) throws NoSuchMethodException {
		if (args == null) args = new Object[0];
		Utils.writeArguments(monitor,MessageMonitor.DEBUG,"MF:SearchStaticMethod:"+cls.getName()+"."+name,args);
		Method m = searchMethodRecursive(cls,name,args,publicClassTable,staticFinder);
		if (m != null) return m;
		throw new NoSuchMethodException("Not found static method => "+cls.getName()+"#"+name+Utils.makeArgumentExp(args));
	}

	public Method searchPublicMethod(Class cls,String name,Object[] args) throws NoSuchMethodException {
		if (args == null) args = new Object[0];
		Utils.writeArguments(monitor,MessageMonitor.DEBUG,"MF:SearchPublicMethod:"+cls.getName()+"."+name,args);
		Method m = searchMethodRecursive(cls,name,args,publicClassTable,publicFinder);
		if (m != null) return m;
		throw new NoSuchMethodException("Not found public instance method => "+cls.getName()+"#"+name+Utils.makeArgumentExp(args));
	}

	public Method searchAllMethod(Class cls,String name,Object[] args) throws NoSuchMethodException {
		if (args == null) args = new Object[0];
		Utils.writeArguments(monitor,MessageMonitor.DEBUG,"MF:SearchAllMethod:"+cls.getName()+"."+name,args);
		Method m = searchMethodRecursive(cls,ObjectManager.METHOD_ORG_PREFIX+name,args,
										 allClassTable,allfinder);
		if (m != null) return m;
		throw new NoSuchMethodException("Not found instance method => "+cls.getName()+"#"+name+Utils.makeArgumentExp(args));
	}

	private Method searchMethodRecursive(Class cls,String name,Object[] args,
										 HashMap classMap,AbstractFinder finder) throws NoSuchMethodException {
		if (cls == null) return null;
		monitor.debug("MF:Searching : "+cls.getName());
		if (!ignoreClass(cls)) {
			Method[] ms = getMethodsGen(cls,name,classMap,finder);
			for(int i=0;i<ms.length;i++) {
				if (isMatched(ms[i],args)) {
					monitor.debug("MF:   Found");
					return ms[i];
				}
			}
		}
		Class[] ifs = cls.getInterfaces();
		for(int i=0;i<ifs.length;i++) {
			Method m = searchMethodRecursive(ifs[i],name,args,classMap,finder);
			if (m != null) return m;
		}
		return searchMethodRecursive(cls.getSuperclass(),name,args,classMap,finder);
	}

	private boolean ignoreClass(Class c) {
		return ((c.getModifiers() & Modifier.PUBLIC)==0 || 
				c == RandomAccess.class || c == Serializable.class);
	}

	private abstract class AbstractFinder {
		abstract List getMethods(Class c);
	}

	private AbstractFinder allfinder = new AbstractFinder() {
			List getMethods(Class cls) {
				Method[] ret = cls.getDeclaredMethods();
				List list = new ArrayList();
				for(int i=0;i<ret.length;i++) {
					if ((ret[i].getModifiers() & Modifier.STATIC)==0) {
						list.add(ret[i]);
					}
				}
				return list;
			}
		};

	private AbstractFinder publicFinder = new AbstractFinder() {
			List getMethods(Class cls) {
				//Method[] ret = cls.getMethods();
				Method[] ret = cls.getDeclaredMethods();
				List list = new ArrayList();
				for(int i=0;i<ret.length;i++) {
					int mod = ret[i].getModifiers();
					if ( (mod & Modifier.STATIC) == 0 & (mod & Modifier.PUBLIC) > 0) {
						list.add(ret[i]);
					}
				}
				return list;
			}
		};

	private AbstractFinder staticFinder = new AbstractFinder() {
			List getMethods(Class cls) {
				Method[] ret = cls.getDeclaredMethods();
				//Method[] ret = cls.getMethods();
				List list = new ArrayList();
				for(int i=0;i<ret.length;i++) {
					if ((ret[i].getModifiers() & Modifier.STATIC)>0) {
						list.add(ret[i]);
					}
				}
				return list;
			}
		};

	private Method[] getMethodsGen(Class cls,String name,HashMap classMap,AbstractFinder finder) {
		HashMap mmap = (HashMap)classMap.get(cls);
		if (mmap == null) {
			mmap = new HashMap();
			classMap.put(cls,mmap);
			monitor.debug("MF. class cache miss: "+cls.getName());
		} else {
			Method[] ms = (Method[])mmap.get(name);
			if (ms != null) {
				return ms;
			}
			Utils.writeArray(monitor,MessageMonitor.DEBUG,new Object[]{"MF. method cache miss: ",cls.getName(),".",name});
		}

		List ms = finder.getMethods(cls);
		List list = new LinkedList();
		for(int i=0;i<ms.size();i++) {
			Method m = (Method)ms.get(i);
			if ( (m.getModifiers() & Modifier.PRIVATE) > 0 ) continue;
			if (m.getName().equals(name)) {
				list.add(m);
			}
		}

		Method[] rms = (Method[])list.toArray(new Method[list.size()]);
		mmap.put(name,rms);
		return rms;
	}

	private boolean isMatched(Method method,Object[] args) {
		return compareParams(method.getParameterTypes(),args);
	}

	private boolean compareParams(Class[] types,Object[] args) {
		if (args.length != types.length) {
			return false;
		}
		if ( args.length == 0 && types.length == 0 ) {
			return true;
		}
		for (int j=0;j<args.length;j++) {
			Object a = args[j];
			Class t = types[j];
			if (!t.isInstance(args[j])) {
				if (t.isPrimitive() && a == null) {
					return false;
				} else if (!t.isPrimitive() && a == null) {
					continue;
				} else if ( (t.equals(Boolean.TYPE) || t.equals(Boolean.class)) &&
							a.getClass().equals(Boolean.class)) {
					continue;
				}
				if (a instanceof Number) {
					if (canConvert(j,args,t)) {
						continue;
					}
				}
				return false;
			}
		}
		return true;
	}

	private boolean canConvert(int j, Object[] args, Class type) {
		Object a = args[j];
		Object ret = Utils.convertObjectType(a,type);
		if (ret == null) {
			return false;
		} else {
			args[j] = ret;
			return true;
		}
	}


}