package jbridge.comm.binstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;


abstract public class AbstractResultObject extends AbstractTransferObject implements BinConstants  {

	protected AbstractResultObject(Object _sid) {
		super(_sid);
	}

	public static AbstractResultObject get(InputStream in) throws IOException {
		DecodeHandlerClass2 ret = new DecodeHandlerClass2();
		BinDecoder.read(in,ret);
		Object sid = ret.value;
		final int[] mcode = {0};
		BinDecoder.read(in,new DecodeHandlerClass() {
				public void readByte(byte c) {
					mcode[0] = c;
				}});
		switch (mcode[0]) {
		case R_OK:
			BinDecoder.read(in,ret);
			Object value = ret.value;
			return new ResultOkObject(sid,value);
		case R_APP_ERROR:
		case R_PROTOCOL_ERROR:
		case R_FATAL_ERROR:
			BinDecoder.read(in,ret);
			String klass = (String)ret.value;
			BinDecoder.read(in,ret);
			String message = (String)ret.value;
			BinDecoder.read(in,ret);
			String detail = (String)ret.value;
			return new ResultErrObject(sid,mcode[0],klass,message,detail);
		default:
			throw new RuntimeException("Unknown return code:"+mcode[0]);
		} 
	}

	protected byte getMessageType() {
		return (byte)M_RETURN;
	}

	//void exec_impl(OutputStream out) throws IOException;

	abstract Object getValue() throws BinStreamException,IOException;
	
}
