package jbridge.comm.binstream;


import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;


public abstract class AbstractTransferObject {

	public final Object sid;

	protected AbstractTransferObject(Object s) {
		sid = s;
	}

	protected abstract void exec_impl(OutputStream out) throws IOException;

	protected abstract byte getMessageType();

	void exec(OutputStream out) throws IOException {
		ByteArrayOutputStream buf = new ByteArrayOutputStream();
		exec_impl(buf);
		ByteArrayOutputStream header = new ByteArrayOutputStream();
		BinEncoder.write(header,getMessageType());
		BinEncoder.write(header,buf.size());
		header.writeTo(out);
		buf.writeTo(out);
		out.flush();
	}

}
