package jbridge.comm.binstream;

import java.io.IOException;
import java.net.Socket;
import jp.gr.java_conf.ccs2.core.MessageMonitor;


public class BinClient implements BinConstants,ICommunicator{

	private MessageMonitor monitor;
	private String host;
	private int port;

	private ServiceManager handlerManager = new ServiceManager();
	private MessageServer messageServer;

	private Thread socketThread;
	private boolean shutdownFlag = false;

	public BinClient(MessageMonitor mon,String host,int port) throws IOException {
		this.monitor = mon;
		messageServer = new MessageServer("CL",monitor,handlerManager);
		this.host = host;
		this.port = port;
	}

	public synchronized void start() {
		shutdownFlag = false;
		socketThread = new Thread(connector);
		socketThread.setName("BCL|socket");
		socketThread.start();
	}

	public synchronized void shutdown() {
		monitor.debug("BinClient: shutdown signal arrived.");
		shutdownFlag = true;
		messageServer.shutdown();
		while(true) {
			if (socketThread == null) {
				break;
			}
			try {
				Thread.sleep(300);
			} catch (InterruptedException e) {
				monitor.recordStackTrace(e);
				return;
			}
		}
		monitor.debug("BinClient: shutdown completed.");
		shutdownFlag = false;
	}

	private Runnable connector = new Runnable() {
			public void run() {
				try {
					while(!shutdownFlag) {
						try {
							monitor.verbose("BinClient: connecting...");
							Socket socket = new Socket(host,port);
							monitor.verbose("BinClient: connection established.");
							messageServer.setSocket(socket);
							messageServer.blockWorkingThread();
							monitor.verbose("BinClient: disconnected.");
						} catch (IOException e) {
							monitor.recordStackTrace(e);
						}
					}
				} finally {
					monitor.debug("BinClient: Connector thread finished.");
					socketThread = null;
				}
			}
		};

	public void addHandler(String name,IMessageHandler h) {
		handlerManager.addHandler(name,h);
	}

	public Object send(String name,Object[] args) throws IOException {
		return messageServer.send(name,args);
	}
	
	public void removeHandler(String name) {
		handlerManager.removeHandler(name);
	}
}
