/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.Window;
import java.awt.Dimension;
import java.awt.Toolkit;


/** utility for swing */
public class SwingUtil {

    /** magnify the all fonts in swing.
		@param mag magnify parameter <br/>
		mag > 1. : large <br/>
		mag < 1. : small
	*/
	public static void magnifyAllFont(float mag) {
		List history = new LinkedList();
		UIDefaults defaults = UIManager.getDefaults();
		Enumeration it = defaults.keys();
		while(it.hasMoreElements()) {
			Object key = it.nextElement();
			Object a = defaults.get(key);
			if (a instanceof Font) {
				if (history.contains(a)) continue;
				Font font = (Font)a;
				font = font.deriveFont(font.getSize2D()*mag);
				defaults.put(key,font);
				history.add(font);
			}
		}
	}

	public static JFrame getTestFrame(String title) {
		JFrame f = new JFrame(title);
		f.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}
			});
		return f;
	}

	/** GUI utility (change border title)
	 * @param panel bborder component
	 * @param title new title
	 */
	public static void borderTitle(JComponent panel,String title) {
		Border b = panel.getBorder();
		if (b instanceof TitledBorder)
			( (TitledBorder) b).setTitle(title);
	}

	/** GUI utility (set frame on the center of screen) */
	public static void setCenter(Window w) {
		Dimension scSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension wndSize = w.getSize();
		w.setLocation( (scSize.width-wndSize.width)/2,
					   (scSize.height-wndSize.height)/2);
	}
}

