/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;
import java.util.*;
import java.text.MessageFormat;


public abstract class AppContextClass implements AppContext {

	protected MessageMonitor monitor;
	protected AppConfig config;
	protected String resourceUri;

	protected AppContextClass(String [] args) {
		this(args,null);
	}

	protected AppContextClass(String [] args,String resourceUri) {
		this.resourceUri = resourceUri;
		config = new DefaultAppConfig(args);
		setupMonitor();
	}

	protected AppContextClass(AppConfig conf,String resourceUri) {
		this.resourceUri = resourceUri;
		config = conf;
		setupMonitor();
	}

	public String getResourceUri() {
		return resourceUri;
	}

	protected void setupMonitor() {
		monitor = new DefaultMonitor(config);
	}

	public AppConfig getConfig() {
		return config;
	}

	public MessageMonitor getMonitor() {
		return monitor;
	}

	public void setMonitor(MessageMonitor m) {
		monitor = m;
	}

	//
	// Handle Resource 
	//
 
	ResourceBundle resources;
	boolean loadFailed = false;

	protected void loadResources() {
		Locale locale = Locale.getDefault();
		try {
			resources = ResourceBundle.getBundle
				(resourceUri,locale);
		} catch (MissingResourceException mre) {
			getMonitor().error("property file ["+resourceUri+"] not found");
			loadFailed = true;
		}
	}

	/**
	   @param resourceName resource name
	   @return string resource. if not found, resourceName is return
	   and warning is reported into warning log.
	 */
	public String getResourceString(String resourceName) {
		if (resources == null && !loadFailed) {
			loadResources();
		}
		try {
			return resources.getString(resourceName);
		} catch (RuntimeException e) {
			getMonitor().warning("no string :"+resourceName);
		}
		return resourceName;
	}

	/**
	   @param resourceName resource name
	   @return string resource. if not found, just return null.
	 */
	public String getResourceStringNoWarning(String resourceName) {
		if (resources == null && !loadFailed) 
			loadResources();
		try {
			return resources.getString(resourceName);
		} catch (RuntimeException e) {
		}
		return null;
	}

	public String getResourceString(String resName,String arg) {
		return MessageFormat.format(getResourceString(resName),new String [] {arg});
	}

}
