/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;
import java.util.ResourceBundle;
import java.util.MissingResourceException;
import java.util.HashMap;
import java.util.List;
import java.util.LinkedList;
import java.util.Enumeration;
import java.util.Iterator;
import java.io.File;
import jp.gr.java_conf.ccs2.util.ResourceFile;

public class DefaultAppConfig extends AppConfig {

	protected static String separator = ":";

	private HashMap table = new HashMap();
	private List fileList = new LinkedList();

	/**
	 * Creates a new <code>DefaultAppConfig</code> instance.
	 *
	 * @param defaultsUri default property file
	 * @param propFile user property file
	 * @param args argument strings
	 */
	public DefaultAppConfig(String defaultsUri,String propFile,
							String [] args) {
		setupDefaults(defaultsUri);
		setupFile(propFile);
		setupArgs(args);
	}

	/**
	 * Creates a new <code>DefaultAppConfig</code> instance.
	 *
	 * @param propFile user property file
	 * @param args argument strings
	 */
	public DefaultAppConfig(String propFile,String [] args) {
		this(null,propFile,args);
	}

	/**
	 * Creates a new <code>DefaultAppConfig</code> instance.
	 *
	 * @param args argument strings
	 */
	public DefaultAppConfig(String [] args) {
		this(null,args);
	}

	protected void setupDefaults(String prop) {
		if (prop == null) return;
		try {
			setupProp(ResourceBundle.getBundle(prop));
		} catch (MissingResourceException e) {
		}
	}

	protected void setupFile(String propFile) {
		if (propFile == null) return;
		File file = new File(propFile);
		if (!file.exists()) {
			return;
		}
		setupProp(ResourceFile.getResourceFile(propFile));
	}

	protected void setupProp(ResourceBundle res) {
		if (res == null) return;
		Enumeration keys = res.getKeys();
		while(keys.hasMoreElements()) {
			String key = (String)keys.nextElement();
			try {
				String cont = res.getString(key);
				setOption(key,cont);
			} catch (MissingResourceException e) {
			}
		}
	}

	private void setOption(String key,String content) {
		if (content.equalsIgnoreCase("true") || 
			content.equalsIgnoreCase("yes")) {
			table.put(key,Boolean.TRUE);
		} else if (content.equalsIgnoreCase("false") || 
				   content.equalsIgnoreCase("no")) {
			table.put(key,Boolean.FALSE);
		} else {
			table.put(key,content);
		}
	}

	protected void setupArgs(String [] args) {
		if (args == null || args.length == 0) return;
		for (int i=0;i<args.length;i++) {
			if (args[i].charAt(0)!='-') {
				fileList.add(args[i]);
				continue;
			}
			int ps = args[i].indexOf(separator);
			if (ps == -1) {
				table.put(args[i].substring(1),Boolean.TRUE);//without content
			} else {
				setOption(args[i].substring(1,ps),//option name
						  args[i].substring(ps+1));//option content
			}
		}
	}

	public String[] getArgumentFiles() {
		String[] rets = new String[fileList.size()];
		return (String[])fileList.toArray(rets);
	}

	public String[] getOptionKeys() {
		String [] ret = new String[table.size()];
		Iterator keys = table.keySet().iterator();
		int i=0;
		while(keys.hasNext()) {
			String key = (String)keys.next();
			ret[i++]= key;
		}
		return ret;
	}

	protected Object getOptionObject(String key) {
		return table.get(key);
	}

}
