/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;
import jp.gr.java_conf.ccs2.io.AbstractReader;
import jp.gr.java_conf.ccs2.io.ConsoleReader;

/** simple utility */
public class EasyMain {
    protected static AbstractReader cin = new ConsoleReader();

    public static void print(String a) {
	System.out.println(a);
    }

    public static String read(String a,String def) {
	print(a+" [ "+def+" ]");
	String r = cin.read(def);
	return r;
    }

    public static int readInteger(String a,int def) {
	print(a+" [ "+def+" ]");
	int r = cin.readInteger(def);
	return r;
    }

    public static long readLong(String a,long def) {
	print(a+" [ "+def+" ]");
	long r = cin.readLong(def);
	return r;
    }

    public static double readDouble(String a,double def) {
	print(a+" [ "+def+" ]");
	double r = cin.readDouble(def);
	return r;
    }
}
