/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;


/** 
	Map MessageMonitor to Logger of Log4J.
	DEBUG -> DEBUG, VERBOSE -> INFO, NORMAL -> WARN, WARNING -> ERROR, ERROR -> FATAL.
 */
public class Log4JMonitor implements MessageMonitor {

	private Logger logger;

	public Log4JMonitor(Logger logger) {
		this.logger = logger;
	}

	public int getLogLevel() {
		Level level = logger.getEffectiveLevel();
		if (Level.DEBUG.equals(level)) {
			return DEBUG;
		} else if (Level.INFO.equals(level)) {
			return VERBOSE;
		} else if (Level.WARN.equals(level)) {
			return NORMAL;
		} else if (Level.ERROR.equals(level)) {
			return WARNING;
		} else if (Level.FATAL.equals(level)) {
			return ERROR;
		} else {
			//should output something?
			return DEBUG;
		}
	}

	public void setLogLevel(int a) {
		switch (a) {
		case DEBUG:
			logger.setLevel(Level.DEBUG);
			break;
		case VERBOSE:
			logger.setLevel(Level.INFO);
		case NORMAL:
			logger.setLevel(Level.WARN);
			break;
		case WARNING:
			logger.setLevel(Level.ERROR);
			break;
		case ERROR:
			logger.setLevel(Level.FATAL);
			break;
		default:
			logger.setLevel(Level.DEBUG);
			logger.warn("Log4JMonitor: LogLevel was set to ["+a+"]");
		}
	}

	public void setLogLevel(String in) {
		for(int i=0;i<LEVELS.length;i++) {
			if (LEVELS[i].equalsIgnoreCase(in)) {
				setLogLevel(i);
				return;
			}
		}
		setLogLevel(NORMAL);
	}

	public String toString() {
		String ret = "CLASS:"+getClass().getName()+", LOGGER:"+logger;
		return ret;
	}

	public void debug(String message) {
		logger.debug(message);
	}
	public void verbose(String message) {
		logger.info(message);
	}
	public void normal(String message) {
		logger.warn(message);
	}
	public void warning(String message) {
		logger.error(message);
	}
	public void error(String message) {
		logger.fatal(message);
	}

	public void message(int level,String message) {
		switch(level) {
		case DEBUG:
			debug(message);
			break;
		case VERBOSE:
			verbose(message);
			break;
		case NORMAL:
			normal(message);
			break;
		case WARNING:
			warning(message);
			break;
		case ERROR:
			error(message);
			break;
		default
			error(message);
			break;
		}
	}

	public void debugStackTrace(String message) {
		logger.debug(message,new Throwable());
	}

	public void recordStackTrace(Throwable t) {
		logger.debug("",t);
	}

}
