/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;
import java.io.*;
import java.util.*;
import jp.gr.java_conf.ccs2.util.StringUtil;


/**
 * This class override given configuration object.
 *
 * @author <a href="mailto:m.sakurai@dream.com">SAKURAI Masashi</a>
 */
public class MutableAppConfig extends AppConfig {

	private static final Object NULL = new Object();

	private AppConfig config;
	private HashMap map = new HashMap();

	public MutableAppConfig(AppConfig parent) {
		config = parent;
	}

	public void setAppContext(AppContext app) {
		config.setAppContext(app);
	}

	public AppContext getAppContext() {
		return config.getAppContext();
	}

	/**
	 * @param content if null, disable the parent configuration.
	 */
	public void setOptionObject(String key,Object content) {
		if (content == null) {
			map.put(key,NULL);
		} else {
			map.put(key,content);
		}
	}

	public String[] getOptionKeys() {
		List keyList = new LinkedList();
		String [] parentKeys = config.getOptionKeys();
		for (int i=0;i<parentKeys.length;i++) {
			if (getOptionObject(parentKeys[i]) == null) {
				continue;
			}
			keyList.add(parentKeys[i]);
		}
		Iterator it = map.keySet().iterator();
		while(it.hasNext()) {
			String key = (String)it.next();
			if (getOptionObject(key) == null || keyList.contains(key)) {
				continue;
			}
			keyList.add(key);
		}
		String[] newKeys = new String[keyList.size()];
		return (String[])keyList.toArray(newKeys);
	}

	public Object getOptionObject(String key) {
		Object obj = map.get(key);
		if (obj == NULL) return null;
		if (obj != null) return obj;
		return config.getOptionObject(key);
	}

	public String [] getArgumentFiles() {
		return config.getArgumentFiles();
	}

	public void save(String filename) throws IOException {
		PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(filename)));
		try {
			String[] keys = getOptionKeys();
			for (int i=0;i<keys.length;i++) {
				if (getOptionObject(keys[i]) != null &&
					getOptionObject(keys[i]) != NULL) {
					out.print(keys[i]);
					out.print("=");
					out.println(getOptionObject(keys[i]).toString());
				}
			}
		} finally {
			out.flush();
			out.close();
		}
	}

	//test method
	public static void main(String [] a) throws IOException {
		String [] args = {"-abc:12","-level:debug","-output:true",
						  "-mag:3.14","-input:false","file1"};
		DefaultAppConfig config = new DefaultAppConfig(args);
		System.out.println(config.getDumpProperties());
		StringUtil.assertEquals(config.getOptionString("level"),"debug");
		if (12 != config.getOptionInteger("abc")) 
			throw new RuntimeException(config.getOptionString("abc"));
		if (!config.getOption("output")) 
			throw new RuntimeException(config.getOptionString("output"));
		if (config.getOption("input")) 
			throw new RuntimeException(config.getOptionString("input"));
		if (3.14 != config.getOptionDouble("mag")) throw new RuntimeException();
		StringUtil.assertEquals("file1",config.getArgumentFile());
		System.out.println("----------------");
		MutableAppConfig nconfig = new MutableAppConfig(config);
		nconfig.setOptionObject("abc","33");
		nconfig.setOptionObject("level",null);
		nconfig.setOptionObject("new","option");
		System.out.println(StringUtil.conbine(nconfig.getOptionKeys(),", "));
		System.out.println(nconfig.getDumpProperties());
		if (nconfig.getOptionString("level") != null) 
			throw new RuntimeException(nconfig.getOptionString("level"));
		if (33 != nconfig.getOptionInteger("abc")) 
			throw new RuntimeException(nconfig.getOptionString("abc"));
		if (!nconfig.getOption("output")) 
			throw new RuntimeException(nconfig.getOptionString("output"));
		if (nconfig.getOption("input")) 
			throw new RuntimeException(nconfig.getOptionString("input"));
		if (3.14 != nconfig.getOptionDouble("mag")) throw new RuntimeException();
		nconfig.save("/temp/test.properties");
	}

}

