/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.sql.db;

import java.sql.*;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;


public class OracleCommand implements NativeDBCommand {

	public String getDBName() {
		return "Oracle";
	}

	public void lockTables(Statement stmt,String [] tables,boolean writeLock) throws SQLException {
		if (tables == null || tables.length == 0) return;
		boolean [] ls = new boolean [tables.length];
		for (int i=0;i<tables.length;i++) {
			ls[i] = writeLock;
		}
		lockTables(stmt,tables,ls);
	}

	/**
	   should be called in the transaction task.
	 */
	public void lockTables(Statement stmt,String [] tables,boolean [] writeLock) throws SQLException {
		if (tables == null || tables.length == 0) return;
		for (int i=0; i<tables.length;i ++) {
			String sql = "LOCK TABLE ";
			sql += tables[i];
			if (writeLock[i]) {
				sql += " IN ACCESS EXCLUSIVE MODE";
			} else {
				sql += " IN ACCESS SHARE MODE";
			}
			stmt.executeUpdate(sql);
		}
	}

	public void unlockTables(Statement stmt,String [] tables) throws SQLException {
		//
	}
	
	private char [] orgChars = {'\\','\"'};
	private String [] replaceChars = {"\\\\","\\\""};

	public String escape(String text) {
		return StringUtil.escape(text,orgChars,replaceChars);
	}
}

