/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.text.MessageFormat;
import java.io.*;

public class NumberFileRotator implements FileRotator {
	
	private String logFile;
	private long logSize;
	private int logNumber;

	public NumberFileRotator(String logFile,long logSize,int logNumber) {
		this.logFile = logFile;
		this.logSize = logSize;
		this.logNumber = logNumber;
	}

	public void setFilename(String path) {
		this.logFile = path;
	}

	public String getFilename() {
		return logFile;
	}

	public void rotate() {
		File file = new File(logFile);
		if (!file.exists() || logSize < 1 || logNumber < 1) {
			return;
		}
		if (file.length() >= logSize) {
			moveOldFiles();
		}
	}

	private static final String FILE_FORMAT = "{0}.{1}";

	private void moveOldFiles() {
		String [] args = new String[2];
		args[0] = logFile;
		for (int i=logNumber;i>=0;i--) {
			File file = null;
			if (i > 0) {
				args[1] = Integer.toString(i);
				file = new File(MessageFormat.format(FILE_FORMAT,args));
			} else {
				file = new File(logFile);
			}
			if (file.exists()) {
				if (i == logNumber) {
					file.delete();
					continue;
				}
				args[1] = Integer.toString(i+1);
				File nextFile = new File(MessageFormat.format(FILE_FORMAT,args));
				file.renameTo(nextFile);
			}
		}
	}
}
