/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.util.*;
import java.text.*;
import java.io.*;


/** String utility */
public class StringUtil {

	static DateFormat ftj_date = DateFormat.getDateInstance(DateFormat.FULL);
	static DateFormat ftj_datetime = DateFormat.getDateTimeInstance(DateFormat.FULL,DateFormat.FULL);
	static DateFormat ftl_date = DateFormat.getDateInstance(DateFormat.MEDIUM);
	static DateFormat ftl_datetime = DateFormat.getDateTimeInstance(DateFormat.MEDIUM ,DateFormat.MEDIUM );

	/** full format the date object with long date type */
	public static String datej(Date d) {
		if (d == null) return "";
		return ftj_date.format(d);
	}

	/** full format the date object with long date-time type */
	public static String dateTimej(Date d) {
		if (d == null) return "";
		return ftj_datetime.format(d);
	}

	/** long format the date object with long date type */
	public static String datel(Date d) {
		if (d == null) return "";
		return ftl_date.format(d);
	}

	/** long format the date object with long date-time type */
	public static String dateTimel(Date d) {
		if (d == null) return "";
		return ftl_datetime.format(d);
	}

	/** if (s == null || s.length == 0) return true; */
	public static final boolean isNull(String s) {
		if (s == null || s.length() == 0) return true;
		return false;
	}

	/** compare two strings, ignoring the space characters	*/
	public static final boolean equalsIgnoreSpace(String a,String b) {
		try {
			return assertEqualsIgnoreSpace(a,b);
		} catch (RuntimeException e) {
		}
		return false;
	}

	/** compare two strings, ignoring the space characters	*/
	public static final boolean assertEqualsIgnoreSpace(String a,String b) {
		if (a.equals(b)) return true;
		int ac = 0,bc = 0;
	outer:
		while (true) {
			char aa=' ',bb=' ';
			while(true) {
				if (ac >= a.length()) break;
				aa = a.charAt(ac);
				ac++;
				if (aa == ' ' || aa == '\t' ||
					aa == '\n' || aa == '\r') { 
					continue;
				}
				break;
			}
			while(true) {
				if (bc >= b.length()) break;
				bb = b.charAt(bc);
				bc++;
				if (bb == ' ' || bb == '\t' ||
					bb == '\n' || bb == '\r' ) { 
					continue;
				}
				break;
			}
			if (ac >= a.length() && bc >= b.length()) break;
			if (aa != bb) {
				String ret = "ASSERT String (ignore space) :\n";
				ret += makeErrorMessage(a,ac-1)+"\n";
				ret += makeErrorMessage(b,bc-1);
				throw new RuntimeException(ret);
			}
		}
		return true;
	}


	static int windowSize = 16;
	
	public static final boolean assertEquals(String a,String b) {
		if (a.equals(b)) return true;
		int rows = 0,cols = 0;
		for (int i=0; i<Math.min(a.length(),b.length());i++) {
			if (a.charAt(i) != b.charAt(i)) {
				String ret = "ASSERT String rows["+rows+"] cols["+cols+"]:\n";
				ret += makeErrorMessage(a,i);
				ret += "\n"+makeErrorMessage(b,i);
				throw new RuntimeException(ret);
			}
			if (a.charAt(i)=='\n') {
				cols = 0; rows ++;
			} else 
				cols++;
		}
		if (a.length() != b.length()) {
			throw new RuntimeException("Length different : left["+a.length()+"] : right["+b.length()+"]");
		}
		return false;
	}

	private static String makeErrorMessage(String in,int pos) {
		String message = "{0}[{1}]{2}";
		Object [] args1 = {
			in.substring(Math.max(0,pos-windowSize),pos),
			in.substring(pos,pos+1),
			in.substring(pos+1,Math.min(in.length(),pos+windowSize))
		};
		return MessageFormat.format(message,args1);
	}
	
	public static String conbine(Object [] ss) {
		String [] args = new String[ss.length];
		for (int i=0;i<args.length;i++) {
			if (ss[i] == null) {
				args[i] = "null";
			} else {
				args[i] = ss[i].toString();
			}
		}
		return conbine(args,"");
	}

	public static String conbine(String [] ss) {
		return conbine(ss,"");
	}

	public static String conbine(String [] ss,String spliter) {
		StringBuffer ret = new StringBuffer();
		for (int i=0;i<ss.length;i++) {
			ret.append(ss[i]).append(spliter);
		}
		if (ss.length == 0) {
			return ret.toString();
		}
		return ret.toString().substring(0,ret.length()-spliter.length());
	}

	/** split given string by space, tab, return or comma */
	public static String [] split(String arg) {
		return split(arg,null);
	}

	/** split given string by given delimiter 
		@param arg input text
		@param dlm one character
		@return splitted text
	*/
	public static String [] split(String arg,String dlm) {
		String [] rets = null;
		if (arg == null) return null;
		if (arg.length() == 0) {
			rets = new String[1];
			rets[0] = "";
			return rets;
		}

		//my custom splitter
		if (dlm != null) {
			Vector list = new Vector();
			int skip = dlm.length();
			int sx = 0;
			while(true) {
				int ps = arg.indexOf(dlm,sx);
				if (ps == 0) {
					//null contents
					list.addElement("");
				} else if (ps == -1) {
					//end of contents
					list.addElement(arg);
					break;
				} else if (arg.charAt(ps-1) == '\\') {
					//escaping delimiter
					String tmp = arg.substring(0,ps-1)+arg.substring(ps);
					sx = ps + skip-1;
					arg = tmp;
					continue;
				} else {
					//normal contents
					list.addElement( arg.substring(0,ps) );
				}
				arg = arg.substring(ps+skip);
				sx = 0;
			}
			rets = new String[list.size()];
			for(int i=0;i<rets.length;i++) {
				rets[i] = ((String)list.elementAt(i)).trim();
			}
			return rets;
		}

		//throw into StringTokenizer
		StringTokenizer st = null;
		if (dlm == null) st = new StringTokenizer(arg);
		else st = new StringTokenizer(arg,dlm);

		rets = new String[st.countTokens()];
		for(int i=0;i<rets.length;i++) {
			rets[i] = st.nextToken();
		}
		return rets;
	}

	/**
	   Escape charactors
	   @param in input text
	   @param orgChars target charactor
	   @param replaceChars replace charactor
	   @return escaped text
	 */
	public static String escape(String in,char [] orgChars,String [] replaceChars) {
		if (in == null || orgChars == null || replaceChars == null ||
			orgChars.length == 0 || replaceChars.length == 0 ) {
			return in;
		}
		for (int i=0;i<orgChars.length;i++) {
			if (in.indexOf(orgChars[i]) == -1) {
				continue;
			}
			in = StringUtil.replace(in,String.valueOf(orgChars[i]),
									replaceChars[i]);
		}
		return in;
	}


	/** Replace substring
		@param in Original string
		@param in target word
		@param in replace word
		@return replaced string
	*/
	public static String replace(String in,String target,String after) {
		if (in == null) return "";
		StringBuffer out = new StringBuffer();
		while(true) {
			int ps = in.indexOf(target);
			if (ps == -1) {
				out.append( in.toString() );
				break;
			}
			out.append( in.substring(0,ps) );
			out.append( after );
			in = in.substring( ps+target.length() );
		}
		return out.toString();
	}

	/** Transform from ZENKAKU to HANKAKU <br>
		@param in original string
		@return transformed string
	*/
	public static String transformZenkakuToHankaku(String in) {
		if (in == null) return null;
		String zenkaku = getResourceString("zenkaku");
		String hankaku = getResourceString("hankaku");
		StringBuffer ret = new StringBuffer();
		for(int i=0;i<in.length();i++) {
			char a = in.charAt(i);
			int ps = zenkaku.indexOf(a);
			if (ps == -1) {
				ret.append(a);
			} else {
				ret.append(hankaku.charAt(ps));
			}
		}
		return ret.toString();
	}

	/** Transform from HANKAKU to ZENKAKU <br>
		@param in original string
		@return transformed string
	*/
	public static String transformHankakuToZenkaku(String in) {
		if (in == null) return null;
		String zenkaku = getResourceString("zenkaku");
		String hankaku = getResourceString("hankaku");
		StringBuffer ret = new StringBuffer();
		for(int i=0;i<in.length();i++) {
			char a = in.charAt(i);
			int ps = hankaku.indexOf(a);
			if (ps == -1) {
				ret.append(a);
			} else {
				ret.append(zenkaku.charAt(ps));
			}
		}
		return ret.toString();
	}

	public static String throw2string(Throwable t) {
		StringWriter sw = new StringWriter();
		t.printStackTrace(new PrintWriter(sw));
		sw.flush();
		return sw.toString();
	}

	public static String stringDump(String in) {
		StringBuffer sb = new StringBuffer();
		for (int i=0;i<in.length();i++) {
			char c = in.charAt(i);
			sb.append(c).append(" : ");
			sb.append(
					  Integer.toHexString((int)c));
			sb.append("\n");
		}
		return sb.toString();
	}

	public static String dumpBinData(byte[] array) {
		StringBuffer sb = new StringBuffer("====(binary dump)======\n");
		for (int i=0;i<(array.length/8+1);i++) {
			int max = Math.min(8,array.length-i*8);
			for (int j=0;j<max;j++) {
				int a = array[j+i*8];
				if (a < 0) a = 256+a;
				String hex = Integer.toHexString(a);
				if (hex.length() < 2) {
					hex = "0"+hex;
				}
				sb.append(hex+" ");
			}
			sb.append(" |");
			try {
				sb.append(new String(array,i*8,max,"SJIS"));
			} catch (UnsupportedEncodingException e){
				sb.append(new String(array,i*8,max));
			}
			sb.append("|\n");
		}
		sb.append("====================");
		return sb.toString();
	}

	public static byte[] str2byte(String in) {
		if (StringUtil.isNull(in)) return null;
		if ( (in.length() % 2) != 0 ) return null;
		byte[] code = new byte[in.length()/2];
		try {
			for(int i=0;i<code.length;i++) {
				String a = in.substring(i*2,i*2+2);
				code[i] = (byte)(255 & Integer.parseInt(a,16));
			}
		} catch (NumberFormatException e) {
			return null;
		}
		return code;
	}

	public static String byte2str(byte[] code) {
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<code.length;i++) {
			int v = 255 & code[i];
			String a = "00"+Integer.toHexString(v);
			sb.append( a.substring(a.length()-2,a.length()) );
		}
		return sb.toString();
	}

	//====================================
	// private area
	//====================================

	public static void main(String [] args) {
		assertEquals(transformZenkakuToHankaku
					 ("This is a pen which h had.\nThank you ery muhD"),"This is a pen which I had.\nThank you very much.");
		assertEquals(transformHankakuToZenkaku
					 ("This is a pen which I had."),"s@@@@@h@D");
	}

	private static ResourceBundle resources;
	private static boolean loadFailed = false;

	/** loading a transfer resource file [zenkaku] */
	private static void loadResources() {
		try {
			resources = ResourceBundle.getBundle("jp.gr.java_conf.ccs2.util.zenkaku");
		} catch (MissingResourceException mre) {
			System.err.println("[strings.properties] not found");
			loadFailed = true;
		}
	}
 
	/** get resource string from properties file "strings.properties" */
	private	 static String getResourceString(String s) {
		if (resources == null && !loadFailed) 
			loadResources();
		try {
			return resources.getString(s);
		} catch (RuntimeException e) {
			System.err.println("no string :"+s);
		}
		return s;
	}

}

